/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.HashSet;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import org.jetbrains.annotations.NotNull;

public class IntelliJLaf
extends DarculaLaf {
    @Override
    public String getName() {
        return "IntelliJ";
    }

    @Override
    protected String getPrefix() {
        return IntelliJLaf.isWindowsNativeLook() ? "intellijlaf_native" : "intellijlaf";
    }

    @Override
    protected DefaultMetalTheme createMetalTheme() {
        return new IdeaBlueMetalTheme();
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults defaults = super.getDefaults();
        if (SystemInfo.isMacOSYosemite) {
            IntelliJLaf.installMacOSXFonts(defaults);
        }
        return defaults;
    }

    private static void installMacOSXFonts(UIDefaults defaults) {
        String face = "HelveticaNeue-Regular";
        String elCapitan = null;
        FontUIResource uiFont = IntelliJLaf.getFont("HelveticaNeue-Regular", elCapitan, 13, 0);
        LafManagerImpl.initFontDefaults(defaults, 13, uiFont);
        for (Object key2 : new HashSet(defaults.keySet())) {
            FontUIResource font;
            Object value = defaults.get(key2);
            if (!(value instanceof FontUIResource) || !(font = (FontUIResource)value).getFamily().equals("Lucida Grande") && !font.getFamily().equals("Serif") || key2.toString().contains("Menu")) continue;
            defaults.put(key2, IntelliJLaf.getFont("HelveticaNeue-Regular", elCapitan, font.getSize(), font.getStyle()));
        }
        FontUIResource uiFont11 = IntelliJLaf.getFont("HelveticaNeue-Regular", elCapitan, 11, 0);
        defaults.put("TableHeader.font", uiFont11);
        FontUIResource buttonFont = IntelliJLaf.getFont("HelveticaNeue-Medium", elCapitan, 13, 0);
        defaults.put("Button.font", buttonFont);
        FontUIResource menuFont = new FontUIResource("Lucida Grande", 0, 14);
        defaults.put("Menu.font", menuFont);
        defaults.put("MenuItem.font", menuFont);
        defaults.put("MenuItem.acceleratorFont", menuFont);
        defaults.put("PasswordField.font", defaults.getFont("TextField.font"));
    }

    @NotNull
    private static FontUIResource getFont(String yosemite, String elCapitan, int size, int style) {
        if (SystemInfo.isMacOSElCapitan && elCapitan != null) {
            FontUIResource fontUIResource;
            block4: {
                try {
                    Font sfFont = Font.createFont(0, new File("/System/Library/Fonts/" + elCapitan + ".otf"));
                    fontUIResource = new FontUIResource(sfFont.deriveFont((float)size + 0.0f));
                    if (fontUIResource != null) break block4;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/IntelliJLaf", "getFont"));
            }
            return fontUIResource;
        }
        FontUIResource fontUIResource = new FontUIResource(yosemite, style, size);
        if (fontUIResource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/IntelliJLaf", "getFont"));
        }
        return fontUIResource;
    }

    public static boolean isGraphite() {
        if (!SystemInfo.isMac) {
            return false;
        }
        try {
            return Foundation.invoke((String)"NSColor", (String)"currentControlTint", (Object[])new Object[0]).intValue() == 6;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Color getSelectedControlColor() {
        return MacUtil.colorFromNative((ID)Foundation.invoke((String)"NSColor", (String)"alternateSelectedControlColor", (Object[])new Object[0]));
    }

    public static boolean isWindowsNativeLook() {
        return SystemInfo.isWindows && Registry.is((String)"ide.intellij.laf.win10.ui");
    }
}

