/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ide.ui.laf.intellij.WinIntelliJButtonPainter;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import sun.swing.SwingUtilities2;

public class WinIntelliJButtonUI
extends DarculaButtonUI {
    private PropertyChangeListener helpButtonListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof AbstractButton && DarculaButtonUI.isHelpButton((JComponent)source)) {
                ((AbstractButton)source).setOpaque(false);
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new WinIntelliJButtonUI();
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener("JButton.buttonType", this.helpButtonListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        b.removePropertyChangeListener("JButton.buttonType", this.helpButtonListener);
        super.uninstallListeners(b);
    }

    @Override
    protected boolean paintDecorations(Graphics2D g, JComponent c) {
        if (WinIntelliJButtonUI.isHelpButton(c)) {
            Icon help = MacIntelliJIconCache.getIcon("winHelp");
            help.paintIcon(c, g, (c.getWidth() - help.getIconWidth()) / 2, (c.getHeight() - help.getIconHeight()) / 2);
            return false;
        }
        Insets i = c.getInsets();
        g.setColor(c.hasFocus() ? UIManager.getColor("Button.intellij.native.activeBackgroundColor") : c.getBackground());
        if (c.getBorder() instanceof WinIntelliJButtonPainter) {
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        } else {
            g.fillRect(i.left, i.top, c.getWidth() - i.left - i.right, c.getHeight() - i.top - i.bottom);
        }
        return true;
    }

    @Override
    protected void setupDefaultButton(JButton button) {
    }

    @Override
    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        g.setColor(UIManager.getColor("Button.disabledText"));
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
    }
}

