/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.MessageDecoder;

public final class SocketLock {
    private static final String PORT_FILE = "port";
    private static final String PORT_LOCK_FILE = "port.lock";
    private static final String TOKEN_FILE = "token";
    private static final String ACTIVATE_COMMAND = "activate ";
    private static final String PID_COMMAND = "pid";
    private static final String PATHS_EOT_RESPONSE = "---";
    private static final String OK_RESPONSE = "ok";
    private final String myConfigPath;
    private final String mySystemPath;
    private final AtomicReference<Consumer<List<String>>> myActivateListener;
    private String myToken;
    private BuiltInServer myServer;

    public SocketLock(@NotNull String configPath, @NotNull String systemPath) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/idea/SocketLock", "<init>"));
        }
        if (systemPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemPath", "com/intellij/idea/SocketLock", "<init>"));
        }
        this.myActivateListener = new AtomicReference();
        this.myConfigPath = SocketLock.canonicalPath(configPath);
        this.mySystemPath = SocketLock.canonicalPath(systemPath);
    }

    public void setExternalInstanceListener(@Nullable Consumer<List<String>> consumer) {
        this.myActivateListener.set(consumer);
    }

    public void dispose() {
        SocketLock.log("enter: dispose()", new Object[0]);
        BuiltInServer server = this.myServer;
        if (server == null) {
            return;
        }
        try {
            Disposer.dispose((Disposable)server);
        }
        catch (Throwable throwable) {
            try {
                this.underLocks(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        FileUtil.delete((File)new File(SocketLock.this.myConfigPath, SocketLock.PORT_FILE));
                        FileUtil.delete((File)new File(SocketLock.this.mySystemPath, SocketLock.PORT_FILE));
                        FileUtil.delete((File)new File(SocketLock.this.mySystemPath, SocketLock.TOKEN_FILE));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                Logger.getInstance(SocketLock.class).warn((Throwable)e);
            }
            throw throwable;
        }
        try {
            this.underLocks(new /* invalid duplicate definition of identical inner class */);
        }
        catch (Exception e) {
            Logger.getInstance(SocketLock.class).warn((Throwable)e);
        }
    }

    @Nullable
    public BuiltInServer getServer() {
        return this.myServer;
    }

    @NotNull
    public ActivateStatus lock() throws Exception {
        ActivateStatus activateStatus = this.lock(ArrayUtil.EMPTY_STRING_ARRAY);
        if (activateStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "lock"));
        }
        return activateStatus;
    }

    @NotNull
    public ActivateStatus lock(@NotNull String[] args) throws Exception {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/idea/SocketLock", "lock"));
        }
        SocketLock.log("enter: lock(config=%s system=%s)", this.myConfigPath, this.mySystemPath);
        ActivateStatus activateStatus = this.underLocks(() -> {
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/idea/SocketLock", "lambda$lock$1"));
            }
            File portMarkerC = new File(this.myConfigPath, PORT_FILE);
            File portMarkerS = new File(this.mySystemPath, PORT_FILE);
            MultiMap portToPath = MultiMap.createSmart();
            SocketLock.addExistingPort(portMarkerC, this.myConfigPath, (MultiMap<Integer, String>)portToPath);
            SocketLock.addExistingPort(portMarkerS, this.mySystemPath, (MultiMap<Integer, String>)portToPath);
            if (!portToPath.isEmpty()) {
                for (Map.Entry entry : portToPath.entrySet()) {
                    ActivateStatus status2 = this.tryActivate((Integer)entry.getKey(), (Collection)entry.getValue(), args);
                    if (status2 == ActivateStatus.NO_INSTANCE) continue;
                    return status2;
                }
            }
            if (SocketLock.isShutdownCommand()) {
                System.exit(0);
            }
            this.myToken = UUID.randomUUID().toString();
            String[] lockedPaths = new String[]{this.myConfigPath, this.mySystemPath};
            int workerCount = PlatformUtils.isIdeaCommunity() || PlatformUtils.isDatabaseIDE() || PlatformUtils.isCidr() ? 1 : 2;
            this.myServer = BuiltInServer.startNioOrOio(workerCount, 6942, 50, false, (NotNullProducer<ChannelHandler>)((NotNullProducer)() -> new MyChannelInboundHandler(lockedPaths, this.myActivateListener, this.myToken)));
            byte[] portBytes = Integer.toString(this.myServer.getPort()).getBytes(CharsetToolkit.UTF8_CHARSET);
            FileUtil.writeToFile((File)portMarkerC, (byte[])portBytes);
            FileUtil.writeToFile((File)portMarkerS, (byte[])portBytes);
            File tokenFile = new File(this.mySystemPath, TOKEN_FILE);
            FileUtil.writeToFile((File)tokenFile, (byte[])this.myToken.getBytes(CharsetToolkit.UTF8_CHARSET));
            PosixFileAttributeView view = Files.getFileAttributeView(tokenFile.toPath(), PosixFileAttributeView.class, new LinkOption[0]);
            if (view != null) {
                try {
                    view.setPermissions(ContainerUtil.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE}));
                }
                catch (IOException e) {
                    SocketLock.log(e);
                }
            }
            SocketLock.log("exit: lock(): succeed", new Object[0]);
            return ActivateStatus.NO_INSTANCE;
        });
        if (activateStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "lock"));
        }
        return activateStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V underLocks(@NotNull Callable<V> action) throws Exception {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/idea/SocketLock", "underLocks"));
        }
        FileUtilRt.createDirectory((File)new File(this.myConfigPath));
        try (FileOutputStream lock1 = new FileOutputStream(new File(this.myConfigPath, PORT_LOCK_FILE), true);){
            V v;
            FileUtilRt.createDirectory((File)new File(this.mySystemPath));
            FileOutputStream lock2 = new FileOutputStream(new File(this.mySystemPath, PORT_LOCK_FILE), true);
            try {
                v = action.call();
            }
            catch (Throwable throwable) {
                lock2.close();
                throw throwable;
            }
            lock2.close();
            return v;
        }
    }

    private static void addExistingPort(@NotNull File portMarker, @NotNull String path, @NotNull MultiMap<Integer, String> portToPath) {
        if (portMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portMarker", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (portToPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portToPath", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (portMarker.exists()) {
            try {
                portToPath.putValue((Object)Integer.parseInt(FileUtilRt.loadFile((File)portMarker)), (Object)path);
            }
            catch (Exception e) {
                SocketLock.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ActivateStatus tryActivate(int portNumber, @NotNull Collection<String> paths, @NotNull String[] args) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"paths", "com/intellij/idea/SocketLock", "tryActivate"}));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"args", "com/intellij/idea/SocketLock", "tryActivate"}));
        }
        SocketLock.log("trying: port=%s", new Object[]{portNumber});
        args = SocketLock.checkForJetBrainsProtocolCommand(args);
        try {
            socket = new Socket(InetAddress.getLoopbackAddress(), portNumber);
            try {
                socket.setSoTimeout(1000);
                result = false;
                in = new DataInputStream(socket.getInputStream());
                ** try [egrp 2[TRYBLOCK] [0 : 155->206)] { 
lbl14:
                // 1 sources

                ** GOTO lbl-1000
            }
            catch (Throwable var11_15) {
                throw var11_15;
lbl-1000:
                // 1 sources

                {
                    while (true) {
                        path = in.readUTF();
                        SocketLock.log("read: path=%s", new Object[]{path});
                        if (!"---".equals(path)) {
                            if (!paths.contains(path)) continue;
                            result = true;
                            continue;
                        }
                        break;
                    }
                }
lbl25:
                // 1 sources

                catch (IOException e) {
                    SocketLock.log("read: %s", new Object[]{e.getMessage()});
                }
                if (result) {
                    block19: {
                        token = FileUtil.loadFile((File)new File(this.mySystemPath, "token"));
                        out = new DataOutputStream(socket.getOutputStream());
                        out.writeUTF("activate " + token + "\u0000" + new File(".").getAbsolutePath() + "\u0000" + StringUtil.join((String[])args, (String)"\u0000"));
                        out.flush();
                        response = in.readUTF();
                        SocketLock.log("read: response=%s", new Object[]{response});
                        if (!response.equals("ok")) break block19;
                        if (SocketLock.isShutdownCommand()) {
                            SocketLock.printPID(portNumber);
                        }
                        var10_14 = ActivateStatus.ACTIVATED;
                        socket.close();
                        v0 = var10_14;
                        if (v0 != null) return v0;
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/idea/SocketLock", "tryActivate"}));
                    }
                    ** try [egrp 5[TRYBLOCK] [4 : 423->438)] { 
lbl45:
                    // 1 sources

                    return ActivateStatus.CANNOT_ACTIVATE;
                    catch (IOException e) {
                        SocketLock.log(e);
                    }
                    return ActivateStatus.CANNOT_ACTIVATE;
                }
                socket.close();
            }
lbl51:
            // 1 sources

            finally {
                socket.close();
            }
        }
        catch (ConnectException e) {
            SocketLock.log("%s (stale port file?)", new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            SocketLock.log(e);
        }
        v1 = ActivateStatus.NO_INSTANCE;
        if (v1 != null) return v1;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/idea/SocketLock", "tryActivate"}));
    }

    private static void printPID(int port) {
        try {
            Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
            socket.setSoTimeout(1000);
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeUTF(PID_COMMAND);
            DataInputStream in = new DataInputStream(socket.getInputStream());
            int pid = 0;
            try {
                while (true) {
                    String s;
                    if (!Pattern.matches("[0-9]+@.*", s = in.readUTF())) {
                        continue;
                    }
                    pid = Integer.parseInt(s.substring(0, s.indexOf(64)));
                    System.err.println(pid);
                }
            }
            catch (IOException e) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isShutdownCommand() {
        return "shutdown".equals(JetBrainsProtocolHandler.getCommand());
    }

    private static String[] checkForJetBrainsProtocolCommand(String[] args) {
        String jbUrl = System.getProperty(JetBrainsProtocolHandler.class.getName());
        if (jbUrl != null) {
            return new String[]{jbUrl};
        }
        return args;
    }

    @NotNull
    private static String canonicalPath(@NotNull String configPath) {
        String string;
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/idea/SocketLock", "canonicalPath"));
        }
        try {
            string = new File(configPath).getCanonicalPath();
        }
        catch (IOException ignore) {
            String string2 = configPath;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "canonicalPath"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "canonicalPath"));
        }
        return string;
    }

    private static void log(Exception e) {
        Logger.getInstance(SocketLock.class).warn((Throwable)e);
    }

    private static void log(String format, Object ... args) {
        Logger logger = Logger.getInstance(SocketLock.class);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(format, args));
        }
    }

    private static class MyChannelInboundHandler
    extends MessageDecoder {
        private final String[] myLockedPaths;
        private final AtomicReference<Consumer<List<String>>> myActivateListener;
        private final String myToken;
        private State myState;

        public MyChannelInboundHandler(@NotNull String[] lockedPaths, @NotNull AtomicReference<Consumer<List<String>>> activateListener, @NotNull String token) {
            if (lockedPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lockedPaths", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "<init>"));
            }
            if (activateListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activateListener", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "<init>"));
            }
            if (token == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SocketLock.TOKEN_FILE, "com/intellij/idea/SocketLock$MyChannelInboundHandler", "<init>"));
            }
            this.myState = State.HEADER;
            this.myLockedPaths = lockedPaths;
            this.myActivateListener = activateListener;
            this.myToken = token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelActive(ChannelHandlerContext context) throws Exception {
            ByteBuf buffer = context.alloc().ioBuffer(1024);
            boolean success = false;
            try {
                ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                for (String path : this.myLockedPaths) {
                    out.writeUTF(path);
                }
                out.writeUTF(SocketLock.PATHS_EOT_RESPONSE);
                out.close();
                success = true;
            }
            finally {
                if (!success) {
                    buffer.release();
                }
            }
            context.writeAndFlush((Object)buffer);
        }

        @Override
        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "messageReceived"));
            }
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "messageReceived"));
            }
            while (true) {
                switch (this.myState) {
                    case HEADER: {
                        ByteBuf buffer = this.getBufferIfSufficient(input, 2, context);
                        if (buffer == null) {
                            return;
                        }
                        this.contentLength = buffer.readUnsignedShort();
                        if (this.contentLength > 8192) {
                            context.close();
                            return;
                        }
                        this.myState = State.CONTENT;
                        break;
                    }
                    case CONTENT: {
                        CharSequence command = this.readChars(input);
                        if (command == null) {
                            return;
                        }
                        if (StringUtil.startsWith((CharSequence)command, (CharSequence)SocketLock.PID_COMMAND)) {
                            ByteBuf buffer = context.alloc().ioBuffer();
                            ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                            String name = ManagementFactory.getRuntimeMXBean().getName();
                            out.writeUTF(name);
                            out.close();
                            context.writeAndFlush((Object)buffer);
                        }
                        if (StringUtil.startsWith((CharSequence)command, (CharSequence)SocketLock.ACTIVATE_COMMAND)) {
                            boolean tokenOK;
                            String data;
                            List args = StringUtil.split((String)data, (String)((data = command.subSequence(SocketLock.ACTIVATE_COMMAND.length(), command.length()).toString()).contains("\u0000") ? "\u0000" : "\ufffd"));
                            boolean bl = tokenOK = !args.isEmpty() && this.myToken.equals(args.get(0));
                            if (!tokenOK) {
                                SocketLock.log(new UnsupportedOperationException("unauthorized request: " + command));
                                Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"activation.auth.title", (Object[])new Object[0]), IdeBundle.message((String)"activation.auth.message", (Object[])new Object[0]), NotificationType.WARNING));
                            } else {
                                Consumer<List<String>> listener2 = this.myActivateListener.get();
                                if (listener2 != null) {
                                    listener2.consume(args.subList(1, args.size()));
                                }
                            }
                            ByteBuf buffer = context.alloc().ioBuffer(4);
                            ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                            out.writeUTF(SocketLock.OK_RESPONSE);
                            out.close();
                            context.writeAndFlush((Object)buffer);
                        }
                        context.close();
                    }
                }
            }
        }

        private static enum State {
            HEADER,
            CONTENT;

        }
    }

    public static enum ActivateStatus {
        ACTIVATED,
        NO_INSTANCE,
        CANNOT_ACTIVATE;

    }
}

