/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.concurrency.JobScheduler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.NetUtils;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DebugAttachDetector {
    private static final Logger LOG = Logger.getInstance(DebugAttachDetector.class);
    private String myHost;
    private int myPort = -1;
    private ScheduledFuture<?> myTask;
    private boolean myAttached;
    private boolean myReady;

    public DebugAttachDetector() {
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        if (!app.isInternal() || app.isUnitTestMode() || app.isHeadlessEnvironment() || "true".equals(System.getProperty("idea.debug.mode"))) {
            return;
        }
        block2: for (String argument : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            String[] params;
            if (!argument.startsWith("-agentlib:jdwp") || !argument.contains("transport=dt_socket")) continue;
            for (String param : params = argument.split(",")) {
                if (!param.startsWith("address")) continue;
                try {
                    String[] address = param.split("=")[1].split(":");
                    if (address.length == 1) {
                        this.myPort = Integer.parseInt(address[0]);
                        break block2;
                    }
                    this.myHost = address[0];
                    this.myPort = Integer.parseInt(address[1]);
                    break block2;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    return;
                }
            }
        }
        if (this.myPort < 0) {
            return;
        }
        this.myTask = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            boolean attached;
            boolean bl = attached = !NetUtils.canConnectToRemoteSocket((String)this.myHost, (int)this.myPort);
            if (!this.myReady) {
                this.myAttached = attached;
                this.myReady = true;
            } else if (attached != this.myAttached) {
                this.myAttached = attached;
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Remote debugger", this.myAttached ? "attached" : "detached", NotificationType.WARNING));
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }
}

