/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.generation.EscapingCommenter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class XmlCommenter
implements EscapingCommenter {
    private static final String DOUBLE_DASH = "--";
    private static final String ESCAPED_DOUBLE_DASH = "&#45;&#45;";
    private static final String GT = ">";
    private static final String ESCAPED_GT = "&gt;";

    public String getLineCommentPrefix() {
        return null;
    }

    @NotNull
    public String getBlockCommentPrefix() {
        if ("<!--" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlCommenter", "getBlockCommentPrefix"));
        }
        return "<!--";
    }

    @NotNull
    public String getBlockCommentSuffix() {
        if ("-->" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlCommenter", "getBlockCommentSuffix"));
        }
        return "-->";
    }

    public String getCommentedBlockCommentPrefix() {
        return "&lt;!&ndash;";
    }

    public String getCommentedBlockCommentSuffix() {
        return "&ndash;&gt;";
    }

    @Override
    public void escape(Document document2, RangeMarker range) {
        String prefix = this.getBlockCommentPrefix();
        String suffix = this.getBlockCommentSuffix();
        int start = range.getStartOffset();
        int prefixStart = start = CharArrayUtil.shiftForward((CharSequence)document2.getCharsSequence(), (int)start, (String)" \t\n");
        if (CharArrayUtil.regionMatches((CharSequence)document2.getCharsSequence(), (int)prefixStart, (CharSequence)prefix)) {
            start += prefix.length();
        }
        int end = range.getEndOffset();
        if (CharArrayUtil.regionMatches((CharSequence)document2.getCharsSequence(), (int)(end - suffix.length()), (CharSequence)suffix)) {
            end -= suffix.length();
        }
        if (start >= end) {
            return;
        }
        for (int i = end - DOUBLE_DASH.length(); i >= start; --i) {
            if (!CharArrayUtil.regionMatches((CharSequence)document2.getCharsSequence(), (int)i, (CharSequence)DOUBLE_DASH) || CharArrayUtil.regionMatches((CharSequence)document2.getCharsSequence(), (int)i, (CharSequence)suffix) || CharArrayUtil.regionMatches((CharSequence)document2.getCharsSequence(), (int)(i - 2), (CharSequence)prefix)) continue;
            document2.replaceString(i, i + DOUBLE_DASH.length(), (CharSequence)ESCAPED_DOUBLE_DASH);
        }
        if (CharArrayUtil.regionMatches((CharSequence)document2.getCharsSequence(), (int)start, (CharSequence)GT)) {
            document2.replaceString(start, start + GT.length(), (CharSequence)ESCAPED_GT);
        }
        if (CharArrayUtil.regionMatches((CharSequence)document2.getCharsSequence(), (int)prefixStart, (CharSequence)(prefix + "-"))) {
            document2.insertString(start, (CharSequence)" ");
        }
        if (CharArrayUtil.regionMatches((CharSequence)document2.getCharsSequence(), (int)(range.getEndOffset() - suffix.length() - 1), (CharSequence)("-" + suffix))) {
            document2.insertString(range.getEndOffset() - suffix.length(), (CharSequence)" ");
        }
    }

    @Override
    public void unescape(Document document2, RangeMarker range) {
        int start = range.getStartOffset();
        for (int i = range.getEndOffset(); i >= start; --i) {
            if (!CharArrayUtil.regionMatches((CharSequence)document2.getCharsSequence(), (int)i, (CharSequence)ESCAPED_DOUBLE_DASH)) continue;
            document2.replaceString(i, i + ESCAPED_DOUBLE_DASH.length(), (CharSequence)DOUBLE_DASH);
        }
        if (CharArrayUtil.regionMatches((CharSequence)document2.getCharsSequence(), (int)start, (CharSequence)ESCAPED_GT)) {
            document2.replaceString(start, start + ESCAPED_GT.length(), (CharSequence)GT);
        }
    }
}

