/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;

public class JoinLinesAction
extends TextComponentEditorAction {
    public JoinLinesAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            Document doc = editor.getDocument();
            LogicalPosition caretPosition = editor.getCaretModel().getLogicalPosition();
            int startLine = caretPosition.line;
            int endLine = startLine + 1;
            if (editor.getSelectionModel().hasSelection()) {
                startLine = doc.getLineNumber(editor.getSelectionModel().getSelectionStart());
                endLine = doc.getLineNumber(editor.getSelectionModel().getSelectionEnd());
                if (doc.getLineStartOffset(endLine) == editor.getSelectionModel().getSelectionEnd()) {
                    --endLine;
                }
            }
            int caretRestoreOffset = -1;
            for (int i = startLine; i < endLine && i < doc.getLineCount() - 1; ++i) {
                int start;
                CharSequence text = doc.getCharsSequence();
                int end = doc.getLineEndOffset(startLine) + doc.getLineSeparatorLength(startLine);
                for (start = end - doc.getLineSeparatorLength(startLine); start > 0 && (text.charAt(start) == ' ' || text.charAt(start) == '\t'); --start) {
                }
                if (caretRestoreOffset == -1) {
                    caretRestoreOffset = start + 1;
                }
                while (end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
                    ++end;
                }
                doc.replaceString(start, end, (CharSequence)" ");
            }
            if (editor.getSelectionModel().hasSelection()) {
                editor.getCaretModel().moveToOffset(editor.getSelectionModel().getSelectionEnd());
            } else if (caretRestoreOffset != -1) {
                editor.getCaretModel().moveToOffset(caretRestoreOffset);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().removeSelection();
            }
        }
    }
}

