/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.awt.Font;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultColorsScheme
extends AbstractColorsScheme
implements ReadOnlyColorsScheme {
    private String myName;

    public DefaultColorsScheme() {
        super(null);
    }

    @Nullable
    public TextAttributes getAttributes(TextAttributesKey key2) {
        if (key2 == null) {
            return null;
        }
        TextAttributes attrs = (TextAttributes)this.myAttributesMap.get(key2);
        if (attrs == null) {
            if (key2.getFallbackAttributeKey() != null && (attrs = this.getFallbackAttributes(key2.getFallbackAttributeKey())) != null && !attrs.isFallbackEnabled()) {
                return attrs;
            }
            attrs = this.getKeyDefaults(key2);
        }
        return attrs;
    }

    @Nullable
    protected TextAttributes getKeyDefaults(@NotNull TextAttributesKey key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/DefaultColorsScheme", "getKeyDefaults"));
        }
        return key2.getDefaultAttributes();
    }

    @Nullable
    public Color getColor(ColorKey key2) {
        if (key2 == null) {
            return null;
        }
        Color color = (Color)this.myColorsMap.get(key2);
        return color != null ? color : key2.getDefaultColor();
    }

    @Override
    public void readExternal(Element parentNode) {
        super.readExternal(parentNode);
        this.myName = parentNode.getAttributeValue("name");
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/DefaultColorsScheme", "getName"));
        }
        return string;
    }

    public void setAttributes(TextAttributesKey key2, TextAttributes attributes) {
    }

    public void setColor(ColorKey key2, Color color) {
    }

    @Override
    public void setFont(EditorFontType key2, Font font) {
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this);
        this.copyTo(newScheme);
        newScheme.setName("Default");
        newScheme.setDefaultMetaInfo(this);
        return newScheme;
    }
}

