/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.ui.Messages;
import org.jetbrains.annotations.NotNull;

public class EditorActionManagerImpl
extends EditorActionManager {
    private final TypedAction myTypedAction = new TypedAction();
    private ReadonlyFragmentModificationHandler myReadonlyFragmentsHandler = new DefaultReadOnlyFragmentModificationHandler();
    private final ActionManager myActionManager;

    public EditorActionManagerImpl(ActionManager actionManager) {
        this.myActionManager = actionManager;
    }

    public EditorActionHandler getActionHandler(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/editor/impl/EditorActionManagerImpl", "getActionHandler"));
        }
        return ((EditorAction)this.myActionManager.getAction(actionId)).getHandler();
    }

    public EditorActionHandler setActionHandler(@NotNull String actionId, @NotNull EditorActionHandler handler2) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/editor/impl/EditorActionManagerImpl", "setActionHandler"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/editor/impl/EditorActionManagerImpl", "setActionHandler"));
        }
        EditorAction action = (EditorAction)this.myActionManager.getAction(actionId);
        return action.setupHandler(handler2);
    }

    @NotNull
    public TypedAction getTypedAction() {
        TypedAction typedAction = this.myTypedAction;
        if (typedAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorActionManagerImpl", "getTypedAction"));
        }
        return typedAction;
    }

    public ReadonlyFragmentModificationHandler getReadonlyFragmentModificationHandler() {
        return this.myReadonlyFragmentsHandler;
    }

    public ReadonlyFragmentModificationHandler getReadonlyFragmentModificationHandler(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorActionManagerImpl", "getReadonlyFragmentModificationHandler"));
        }
        Document doc = document2 instanceof DocumentWindow ? ((DocumentWindow)document2).getDelegate() : document2;
        ReadonlyFragmentModificationHandler docHandler = doc instanceof DocumentImpl ? ((DocumentImpl)doc).getReadonlyFragmentModificationHandler() : null;
        return docHandler == null ? this.myReadonlyFragmentsHandler : docHandler;
    }

    public void setReadonlyFragmentModificationHandler(@NotNull Document document2, ReadonlyFragmentModificationHandler handler2) {
        Document doc;
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorActionManagerImpl", "setReadonlyFragmentModificationHandler"));
        }
        Document document3 = doc = document2 instanceof DocumentWindow ? ((DocumentWindow)document2).getDelegate() : document2;
        if (doc instanceof DocumentImpl) {
            ((DocumentImpl)document2).setReadonlyFragmentModificationHandler(handler2);
        }
    }

    public ReadonlyFragmentModificationHandler setReadonlyFragmentModificationHandler(@NotNull ReadonlyFragmentModificationHandler handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/editor/impl/EditorActionManagerImpl", "setReadonlyFragmentModificationHandler"));
        }
        ReadonlyFragmentModificationHandler oldHandler = this.myReadonlyFragmentsHandler;
        this.myReadonlyFragmentsHandler = handler2;
        return oldHandler;
    }

    private static class DefaultReadOnlyFragmentModificationHandler
    implements ReadonlyFragmentModificationHandler {
        private DefaultReadOnlyFragmentModificationHandler() {
        }

        public void handle(ReadOnlyFragmentModificationException e) {
            Messages.showErrorDialog((String)EditorBundle.message((String)"guarded.block.modification.attempt.error.message", (Object[])new Object[0]), (String)EditorBundle.message((String)"guarded.block.modification.attempt.error.title", (Object[])new Object[0]));
        }
    }
}

