/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.AbstractMappingStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.CacheEntry;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingUtil;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabData;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VisualToLogicalCalculationStrategy
extends AbstractMappingStrategy<LogicalPosition> {
    private final CacheEntry mySearchKey;
    private VisualPosition myTargetVisual;

    VisualToLogicalCalculationStrategy(@NotNull EditorEx editor, @NotNull SoftWrapsStorage storage2, @NotNull List<CacheEntry> cache) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/VisualToLogicalCalculationStrategy", "<init>"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/openapi/editor/impl/softwrap/mapping/VisualToLogicalCalculationStrategy", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/openapi/editor/impl/softwrap/mapping/VisualToLogicalCalculationStrategy", "<init>"));
        }
        super(editor, storage2, cache);
        this.mySearchKey = new CacheEntry(0, editor);
    }

    public void init(@NotNull VisualPosition targetVisual, @NotNull List<CacheEntry> cache) {
        if (targetVisual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetVisual", "com/intellij/openapi/editor/impl/softwrap/mapping/VisualToLogicalCalculationStrategy", "init"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/openapi/editor/impl/softwrap/mapping/VisualToLogicalCalculationStrategy", "init"));
        }
        this.reset();
        this.myTargetVisual = targetVisual;
        this.mySearchKey.visualLine = targetVisual.line;
        int i = Collections.binarySearch(cache, this.mySearchKey);
        if (i >= 0) {
            CacheEntry cacheEntry = cache.get(i);
            if (cacheEntry.visualLine == targetVisual.line) {
                if (targetVisual.column == 0) {
                    this.setEagerMatch(cacheEntry.buildStartLinePosition().buildLogicalPosition());
                } else if (targetVisual.column == cacheEntry.endVisualColumn) {
                    this.setEagerMatch(cacheEntry.buildEndLinePosition().buildLogicalPosition());
                } else if (targetVisual.column > cacheEntry.endVisualColumn) {
                    EditorPosition position = cacheEntry.buildEndLinePosition();
                    int columnsDiff = targetVisual.column - cacheEntry.endVisualColumn;
                    position.visualColumn += columnsDiff;
                    if (this.myStorage.getSoftWrap(cacheEntry.endOffset) == null) {
                        position.logicalColumn += columnsDiff;
                    } else {
                        position.softWrapColumnDiff += columnsDiff;
                    }
                    this.setEagerMatch(position.buildLogicalPosition());
                } else {
                    this.setTargetEntry(cacheEntry, true);
                }
            } else {
                this.setInitialPosition(cacheEntry.buildStartLinePosition());
            }
            return;
        }
        if ((i = -i - 1) > 0 && i <= cache.size()) {
            CacheEntry entry = cache.get(i - 1);
            EditorPosition position = entry.buildEndLinePosition();
            position.onNewLineSoftWrapAware();
            this.setInitialPosition(position);
        } else {
            this.setFirstInitialPosition();
        }
    }

    @Override
    protected LogicalPosition buildIfExceeds(EditorPosition position, int offset) {
        DocumentEx document2 = this.myEditor.getDocument();
        CacheEntry targetEntry = this.getTargetEntry();
        if (targetEntry != null && targetEntry.startOffset == offset && this.myStorage.getSoftWrap(offset) != null) {
            return null;
        }
        int i = MappingUtil.getCacheEntryIndexForOffset(offset, document2, this.myCache);
        if (i < 0) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)this.myCache.get(i);
        if (cacheEntry.visualLine < this.myTargetVisual.line) {
            return null;
        }
        if (offset < cacheEntry.startOffset || this.myTargetVisual.line < cacheEntry.visualLine || position.visualColumn + offset - position.offset >= this.myTargetVisual.column) {
            int linesDiff = this.myTargetVisual.line - position.visualLine;
            if (linesDiff > 0) {
                position.logicalColumn = this.myTargetVisual.column;
                position.offset = document2.getLineStartOffset(position.logicalLine + linesDiff);
                position.offset += this.myTargetVisual.column;
            } else {
                int columnsDiff = this.myTargetVisual.column - position.visualColumn;
                position.logicalColumn += columnsDiff;
                position.offset += columnsDiff;
            }
            position.offset = Math.min(position.offset, document2.getLineEndOffset(position.logicalLine));
            position.visualLine += linesDiff;
            position.visualColumn = this.myTargetVisual.column;
            position.logicalLine += linesDiff;
            return position.buildLogicalPosition();
        }
        return null;
    }

    @Override
    @Nullable
    public LogicalPosition processSoftWrap(@NotNull EditorPosition position, SoftWrap softWrap) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/VisualToLogicalCalculationStrategy", "processSoftWrap"));
        }
        CacheEntry targetEntry = this.getTargetEntry();
        if (targetEntry != null && targetEntry.startOffset == softWrap.getStart()) {
            if (this.myTargetVisual.column <= softWrap.getIndentInColumns()) {
                EditorPosition resultingContext = targetEntry.buildStartLinePosition();
                resultingContext.visualColumn = this.myTargetVisual.column;
                resultingContext.softWrapColumnDiff += this.myTargetVisual.column;
                return resultingContext.buildLogicalPosition();
            }
            position.visualColumn = softWrap.getIndentInColumns();
            position.softWrapColumnDiff += softWrap.getIndentInColumns();
            return null;
        }
        return null;
    }

    @Override
    protected LogicalPosition buildIfExceeds(@NotNull EditorPosition context, @NotNull FoldRegion foldRegion) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/editor/impl/softwrap/mapping/VisualToLogicalCalculationStrategy", "buildIfExceeds"));
        }
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/softwrap/mapping/VisualToLogicalCalculationStrategy", "buildIfExceeds"));
        }
        String placeholder = foldRegion.getPlaceholderText();
        if (this.myTargetVisual.column < context.visualColumn + placeholder.length()) {
            return context.buildLogicalPosition();
        }
        return null;
    }

    @Override
    protected LogicalPosition buildIfExceeds(EditorPosition context, TabData tabData) {
        if (context.visualColumn + tabData.widthInColumns >= this.myTargetVisual.column) {
            context.logicalColumn += this.myTargetVisual.column - context.visualColumn;
            context.visualColumn = this.myTargetVisual.column;
            return context.buildLogicalPosition();
        }
        return null;
    }

    @Override
    @NotNull
    public LogicalPosition build(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/VisualToLogicalCalculationStrategy", "build"));
        }
        int linesDiff = this.myTargetVisual.line - position.visualLine;
        if (linesDiff <= 0) {
            int columnsDiff = this.myTargetVisual.column - position.visualColumn;
            position.logicalColumn += columnsDiff;
            position.offset += columnsDiff;
        } else {
            position.logicalLine += linesDiff;
            position.visualLine += linesDiff;
            DocumentEx document2 = this.myEditor.getDocument();
            if (document2.getLineCount() <= position.logicalLine) {
                position.offset = Math.max(0, document2.getTextLength() - 1);
            } else {
                int startLineOffset = document2.getLineStartOffset(position.logicalLine);
                position.offset = startLineOffset + this.myTargetVisual.column;
            }
            position.logicalColumn = this.myTargetVisual.column;
        }
        position.visualColumn = this.myTargetVisual.column;
        LogicalPosition logicalPosition = position.buildLogicalPosition();
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/VisualToLogicalCalculationStrategy", "build"));
        }
        return logicalPosition;
    }
}

