/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.http;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.BaseRemoteFileEditor;
import com.intellij.openapi.fileEditor.impl.http.RemoteFilePanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HttpFileEditor
extends BaseRemoteFileEditor {
    private final RemoteFilePanel myPanel;

    public HttpFileEditor(@NotNull Project project2, @NotNull HttpVirtualFile virtualFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/http/HttpFileEditor", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/http/HttpFileEditor", "<init>"));
        }
        super(project2);
        this.myPanel = new RemoteFilePanel(project2, virtualFile, this);
        RemoteFileInfo fileInfo = virtualFile.getFileInfo();
        assert (fileInfo != null);
        fileInfo.download().done(file2 -> ApplicationManager.getApplication().invokeLater(() -> this.contentLoaded(), this.myProject.getDisposed())).rejected(throwable -> this.contentRejected());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel.getMainPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/http/HttpFileEditor", "getComponent"));
        }
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            return textEditor.getPreferredFocusedComponent();
        }
        return this.myPanel.getMainPanel();
    }

    @NotNull
    public String getName() {
        if ("Http" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/http/HttpFileEditor", "getName"));
        }
        return "Http";
    }

    public void selectNotify() {
        this.myPanel.selectNotify();
    }

    public void deselectNotify() {
        this.myPanel.deselectNotify();
    }

    @Override
    @Nullable
    protected TextEditor getTextEditor() {
        return this.myPanel.getFileEditor();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myPanel.dispose();
    }
}

