/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.ShortcutPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

abstract class ShortcutDialog<T extends Shortcut>
extends DialogWrapper {
    private final SimpleColoredComponent myAction = new SimpleColoredComponent();
    private final JBPanel myConflictsContainer = new JBPanel((LayoutManager)new VerticalLayout(0));
    private final JBPanel myConflictsPanel = new JBPanel((LayoutManager)new BorderLayout()).withBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)0, (int)10)).withPreferredHeight(64).withMinimumHeight(64);
    protected final ShortcutPanel<T> myShortcutPanel;
    private final Project myProject;
    private String myActionId;
    private Keymap myKeymap;
    private Group myGroup;

    ShortcutDialog(Component parent, String title, ShortcutPanel<T> panel) {
        super(parent, true);
        this.myShortcutPanel = panel;
        this.myProject = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(parent));
        this.setTitle(KeyMapBundle.message((String)title, (Object[])new Object[0]));
    }

    String getActionPath(String actionId) {
        return this.myGroup == null ? null : this.myGroup.getActionQualifiedPath(actionId);
    }

    boolean hasConflicts() {
        return this.myConflictsPanel.isVisible();
    }

    abstract Collection<String> getConflicts(T var1, String var2, Keymap var3);

    abstract T toShortcut(Object var1);

    void setShortcut(T shortcut) {
        if (!ShortcutDialog.equal(shortcut, this.myShortcutPanel.getShortcut())) {
            this.myShortcutPanel.setShortcut(shortcut);
        }
        this.myConflictsContainer.removeAll();
        if (shortcut != null) {
            for (String id : this.getConflicts(shortcut, this.myActionId, this.myKeymap)) {
                String path = id.equals(this.myActionId) ? null : this.getActionPath(id);
                if (path == null) continue;
                SimpleColoredComponent component = new SimpleColoredComponent();
                ShortcutDialog.fill(component, id, path);
                this.myConflictsContainer.add("TOP", (Component)component);
            }
            this.myConflictsPanel.revalidate();
            this.myConflictsPanel.repaint();
        }
        this.myConflictsPanel.setVisible(0 < this.myConflictsContainer.getComponentCount());
    }

    T showAndGet(String id, Keymap keymap, QuickList ... lists) {
        Shortcut shortcut;
        this.myActionId = id;
        this.myKeymap = keymap;
        this.myGroup = ActionsTreeUtil.createMainGroup(this.myProject, keymap, lists, null, false, null);
        ShortcutDialog.fill(this.myAction, id, this.getActionPath(id));
        T firstShortcut = null;
        Shortcut[] shortcutArray = keymap.getShortcuts(id);
        int n = shortcutArray.length;
        for (int i = 0; i < n && (firstShortcut = (T)this.toShortcut(shortcut = shortcutArray[i])) == null; ++i) {
        }
        this.setShortcut(firstShortcut);
        return this.showAndGet() ? (T)this.myShortcutPanel.getShortcut() : null;
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return JBUI.Borders.empty();
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JComponent panel = super.createSouthPanel();
        if (panel != null) {
            panel.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        }
        return panel;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        this.myAction.setIpad((Insets)JBUI.insets((int)10, (int)10, (int)5, (int)10));
        this.myShortcutPanel.addPropertyChangeListener("shortcut", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                ShortcutDialog.this.setShortcut(ShortcutDialog.this.toShortcut(event.getNewValue()));
            }
        });
        JBPanel result2 = new JBPanel((LayoutManager)new BorderLayout()).withPreferredWidth(300).withMinimumWidth(200);
        result2.add("North", (Component)this.myAction);
        result2.add("South", this.myShortcutPanel);
        return result2;
    }

    protected JComponent createCenterPanel() {
        JLabel icon = new JLabel(AllIcons.General.BalloonWarning);
        icon.setVerticalAlignment(1);
        JLabel label = new JLabel(KeyMapBundle.message((String)"dialog.conflicts.text", (Object[])new Object[0]));
        label.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        JScrollPane scroll = ScrollPaneFactory.createScrollPane(null, (boolean)true);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setViewport((JViewport)((Object)new GradientViewport((Component)this.myConflictsContainer, (Insets)JBUI.insets((int)5), false)));
        if (!Registry.is((String)"ide.scroll.new.layout")) {
            scroll.getVerticalScrollBar().setUI(ButtonlessScrollBarUI.createTransparent());
        }
        scroll.getVerticalScrollBar().setUnitIncrement(JBUI.scale((int)10));
        scroll.getVerticalScrollBar().setOpaque(false);
        scroll.getViewport().setOpaque(false);
        scroll.setOpaque(false);
        JBPanel panel = new JBPanel((LayoutManager)new BorderLayout());
        panel.add("North", (Component)label);
        panel.add("Center", (Component)scroll);
        this.myConflictsPanel.add("West", (Component)icon);
        this.myConflictsPanel.add("Center", (Component)panel);
        this.myConflictsContainer.setOpaque(false);
        return this.myConflictsPanel;
    }

    private static boolean equal(Shortcut newShortcut, Shortcut oldShortcut) {
        return newShortcut == null ? oldShortcut == null : newShortcut.equals(oldShortcut);
    }

    private static void fill(SimpleColoredComponent component, String id, String path) {
        if (path == null) {
            component.append(id, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        } else {
            int index = path.lastIndexOf(" | ");
            if (index < 0) {
                component.append(path, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                component.append(path.substring(index + 3), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                component.append(" in ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                component.append(path.substring(0, index), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    }
}

