/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkListConfigurable
extends BaseStructureConfigurable {
    private final ProjectSdksModel myJdksTreeModel;
    private final SdkModel.Listener myListener = new SdkModel.Listener(){

        public void sdkAdded(Sdk sdk) {
        }

        public void beforeSdkRemove(Sdk sdk) {
        }

        public void sdkChanged(Sdk sdk, String previousName) {
            this.updateName();
        }

        public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
            this.updateName();
        }

        private void updateName() {
            NamedConfigurable configurable;
            TreePath path = JdkListConfigurable.this.myTree.getSelectionPath();
            if (path != null && (configurable = ((MasterDetailsComponent.MyNode)path.getLastPathComponent()).getConfigurable()) != null && configurable instanceof JdkConfigurable) {
                configurable.updateName();
            }
        }
    };

    public JdkListConfigurable(Project project2, ProjectStructureConfigurable root) {
        super(project2);
        this.myJdksTreeModel = root.getProjectJdksModel();
        this.myJdksTreeModel.addListener(this.myListener);
    }

    protected String getComponentStateKey() {
        return "JdkListConfigurable.UI";
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    @Nls
    public String getDisplayName() {
        return "SDKs";
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return this.myCurrentConfigurable != null ? this.myCurrentConfigurable.getHelpTopic() : "reference.settingsdialog.project.structure.jdk";
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("jdk.list" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable", "getId"));
        }
        return "jdk.list";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Override
    protected void loadTree() {
        HashMap<Sdk, Sdk> sdks = this.myJdksTreeModel.getProjectSdks();
        for (Sdk sdk : sdks.keySet()) {
            JdkConfigurable configurable = new JdkConfigurable((ProjectJdkImpl)((Object)sdks.get(sdk)), this.myJdksTreeModel, this.TREE_UPDATER, this.myHistory, this.myProject);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)configurable), this.myRoot);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<SdkProjectStructureElement> result2 = new ArrayList<SdkProjectStructureElement>();
        for (Sdk sdk : this.myJdksTreeModel.getProjectSdks().values()) {
            result2.add(new SdkProjectStructureElement(this.myContext, sdk));
        }
        ArrayList<SdkProjectStructureElement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable", "getProjectStructureElements"));
        }
        return arrayList;
    }

    public boolean addJdkNode(Sdk jdk2, boolean selectInTree) {
        if (!this.myUiDisposed) {
            this.myContext.getDaemonAnalyzer().queueUpdate(new SdkProjectStructureElement(this.myContext, jdk2));
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new JdkConfigurable((ProjectJdkImpl)jdk2, this.myJdksTreeModel, this.TREE_UPDATER, this.myHistory, this.myProject)), this.myRoot);
            if (selectInTree) {
                this.selectNodeInTree((DefaultMutableTreeNode)MasterDetailsComponent.findNodeByObject((TreeNode)this.myRoot, (Object)jdk2));
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        this.myJdksTreeModel.removeListener(this.myListener);
        this.myJdksTreeModel.disposeUIResources();
    }

    public ProjectSdksModel getJdksTreeModel() {
        return this.myJdksTreeModel;
    }

    @Override
    public void reset() {
        super.reset();
        this.myTree.setRootVisible(false);
    }

    public void apply() throws ConfigurationException {
        boolean modifiedJdks = false;
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            NamedConfigurable configurable = ((MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i)).getConfigurable();
            if (!configurable.isModified()) continue;
            configurable.apply();
            modifiedJdks = true;
        }
        if (this.myJdksTreeModel.isModified() || modifiedJdks) {
            this.myJdksTreeModel.apply(this);
        }
        this.myJdksTreeModel.setProjectSdk(ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk());
    }

    public boolean isModified() {
        return super.isModified() || this.myJdksTreeModel.isModified();
    }

    public static JdkListConfigurable getInstance(Project project2) {
        return (JdkListConfigurable)((Object)ServiceManager.getService((Project)project2, JdkListConfigurable.class));
    }

    @Override
    public BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.jdk.text", (Object[])new Object[0])){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                DefaultActionGroup group = new DefaultActionGroup(ProjectBundle.message((String)"add.new.jdk.text", (Object[])new Object[0]), true);
                JdkListConfigurable.this.myJdksTreeModel.createAddActions(group, (JComponent)JdkListConfigurable.this.myTree, (Consumer<Sdk>)((Consumer)projectJdk -> JdkListConfigurable.this.addJdkNode((Sdk)projectJdk, true)));
                AnAction[] anActionArray = group.getChildren(null);
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable$2", "getChildren"));
                }
                return anActionArray;
            }
        };
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new SdkRemoveHandler());
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select an SDK to view or edit its details here";
    }

    private class SdkRemoveHandler
    extends RemoveConfigurableHandler<Sdk> {
        public SdkRemoveHandler() {
            super(JdkConfigurable.class);
        }

        @Override
        public boolean remove(@NotNull Collection<Sdk> sdks) {
            if (sdks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdks", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable$SdkRemoveHandler", "remove"));
            }
            for (Sdk sdk : sdks) {
                JdkListConfigurable.this.myJdksTreeModel.removeSdk(sdk);
                JdkListConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new SdkProjectStructureElement(JdkListConfigurable.this.myContext, sdk));
            }
            return true;
        }
    }
}

