/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Iterator;

abstract class AbstractIgnoredFilesHolder
implements FileHolder,
IgnoredFilesHolder {
    protected final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;

    protected AbstractIgnoredFilesHolder(Project project2) {
        this.myProject = project2;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
    }

    protected abstract void removeFile(VirtualFile var1);

    protected abstract Collection<VirtualFile> keys();

    @Override
    public void cleanAndAdjustScope(VcsModifiableDirtyScope scope) {
        if (this.myProject.isDisposed()) {
            return;
        }
        Iterator<VirtualFile> iterator = this.keys().iterator();
        while (iterator.hasNext()) {
            VirtualFile file2 = iterator.next();
            if (!this.isFileDirty((VcsDirtyScope)scope, file2)) continue;
            iterator.remove();
        }
    }

    protected boolean isFileDirty(VcsDirtyScope scope, VirtualFile file2) {
        if (!file2.isValid()) {
            return true;
        }
        final AbstractVcs[] vcsArr = new AbstractVcs[1];
        if (scope.belongsTo(VcsUtil.getFilePath((VirtualFile)file2), (Consumer)new Consumer<AbstractVcs>(){

            public void consume(AbstractVcs vcs) {
                vcsArr[0] = vcs;
            }
        })) {
            return true;
        }
        return vcsArr[0] == null;
    }

    protected boolean fileDropped(VirtualFile file2) {
        return !file2.isValid() || this.myVcsManager.getVcsFor(file2) == null;
    }
}

