/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.AppTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VetoSavingCommittingDocumentsAdapter
implements ApplicationComponent {
    static final Object SAVE_DENIED = new Object();
    private final FileDocumentManager myFileDocumentManager;

    public VetoSavingCommittingDocumentsAdapter(FileDocumentManager fileDocumentManager) {
        this.myFileDocumentManager = fileDocumentManager;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("VetoSavingComittingDocumentsAdapter" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VetoSavingCommittingDocumentsAdapter", "getComponentName"));
        }
        return "VetoSavingComittingDocumentsAdapter";
    }

    public void initComponent() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void beforeAllDocumentsSaving() {
                Map documentsToWarn = VetoSavingCommittingDocumentsAdapter.this.getDocumentsBeingCommitted();
                if (!documentsToWarn.isEmpty()) {
                    boolean allowSave = VetoSavingCommittingDocumentsAdapter.this.showAllowSaveDialog(documentsToWarn);
                    VetoSavingCommittingDocumentsAdapter.updateSaveability(documentsToWarn, allowSave);
                }
            }
        });
    }

    private Map<Document, Project> getDocumentsBeingCommitted() {
        HashMap documentsToWarn = ContainerUtil.newHashMap();
        for (Document unsavedDocument : this.myFileDocumentManager.getUnsavedDocuments()) {
            Object data = unsavedDocument.getUserData(CommitHelper.DOCUMENT_BEING_COMMITTED_KEY);
            if (!(data instanceof Project)) continue;
            documentsToWarn.put(unsavedDocument, (Project)data);
        }
        return documentsToWarn;
    }

    private static void updateSaveability(Map<Document, Project> documentsToWarn, boolean allowSave) {
        Object newValue = allowSave ? null : SAVE_DENIED;
        for (Document document2 : documentsToWarn.keySet()) {
            Project oldData = documentsToWarn.get(document2);
            ((UserDataHolderEx)document2).replace(CommitHelper.DOCUMENT_BEING_COMMITTED_KEY, (Object)oldData, newValue);
        }
    }

    public void disposeComponent() {
    }

    boolean showAllowSaveDialog(Map<Document, Project> documentsToWarn) {
        StringBuilder messageBuilder = new StringBuilder("The following " + (documentsToWarn.size() == 1 ? "file is" : "files are") + " currently being committed to the VCS. Saving now could cause inconsistent data to be committed.\n");
        for (Document document2 : documentsToWarn.keySet()) {
            VirtualFile file2 = this.myFileDocumentManager.getFile(document2);
            messageBuilder.append(FileUtil.toSystemDependentName((String)file2.getPath())).append("\n");
        }
        messageBuilder.append("Save the ").append(documentsToWarn.size() == 1 ? "file" : "files").append(" now?");
        Project project2 = documentsToWarn.values().iterator().next();
        int rc = Messages.showOkCancelDialog((Project)project2, (String)messageBuilder.toString(), (String)"Save Files During Commit", (String)"Save Now", (String)"Postpone Save", (Icon)Messages.getQuestionIcon());
        return rc == 0;
    }
}

