/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnshelvePatchDefaultExecutor
extends ApplyPatchDefaultExecutor {
    private static final Logger LOG = Logger.getInstance(UnshelvePatchDefaultExecutor.class);
    @NotNull
    private final ShelvedChangeList myCurrentShelveChangeList;
    @NotNull
    private final List<ShelvedBinaryFilePatch> myBinaryShelvedPatches;

    public UnshelvePatchDefaultExecutor(@NotNull Project project2, @NotNull ShelvedChangeList changeList, @NotNull List<ShelvedBinaryFilePatch> binaryShelvedPatches) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/UnshelvePatchDefaultExecutor", "<init>"));
        }
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/patch/UnshelvePatchDefaultExecutor", "<init>"));
        }
        if (binaryShelvedPatches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryShelvedPatches", "com/intellij/openapi/vcs/changes/patch/UnshelvePatchDefaultExecutor", "<init>"));
        }
        super(project2);
        this.myCurrentShelveChangeList = changeList;
        this.myBinaryShelvedPatches = binaryShelvedPatches;
    }

    @Override
    public void apply(@NotNull List<FilePatch> remaining, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> patchGroupsToApply, @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        if (remaining == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remaining", "com/intellij/openapi/vcs/changes/patch/UnshelvePatchDefaultExecutor", "apply"));
        }
        if (patchGroupsToApply == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchGroupsToApply", "com/intellij/openapi/vcs/changes/patch/UnshelvePatchDefaultExecutor", "apply"));
        }
        CommitContext commitContext = new CommitContext();
        UnshelvePatchDefaultExecutor.applyAdditionalInfoBefore(this.myProject, additionalInfo, commitContext);
        Collection<PatchApplier> appliers = this.getPatchAppliers(patchGroupsToApply, localList, commitContext);
        ApplyPatchStatus patchStatus = this.executeAndApplyAdditionalInfo(localList, additionalInfo, commitContext, appliers);
        if (patchStatus != ApplyPatchStatus.ABORT && patchStatus != ApplyPatchStatus.FAILURE) {
            this.removeAppliedAndSaveRemainedIfNeeded(remaining, appliers, commitContext);
        }
    }

    private void removeAppliedAndSaveRemainedIfNeeded(@NotNull List<FilePatch> remaining, @NotNull Collection<PatchApplier> appliers, @NotNull CommitContext commitContext) {
        if (remaining == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remaining", "com/intellij/openapi/vcs/changes/patch/UnshelvePatchDefaultExecutor", "removeAppliedAndSaveRemainedIfNeeded"));
        }
        if (appliers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appliers", "com/intellij/openapi/vcs/changes/patch/UnshelvePatchDefaultExecutor", "removeAppliedAndSaveRemainedIfNeeded"));
        }
        if (commitContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "com/intellij/openapi/vcs/changes/patch/UnshelvePatchDefaultExecutor", "removeAppliedAndSaveRemainedIfNeeded"));
        }
        ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(this.myProject);
        if (!shelveChangesManager.isRemoveFilesFromShelf()) {
            return;
        }
        try {
            ArrayList textPatches = ContainerUtil.newArrayList(remaining);
            ArrayList remainingBinaries = ContainerUtil.newArrayList(this.myBinaryShelvedPatches);
            for (PatchApplier applier : appliers) {
                textPatches.addAll(applier.getRemainingPatches());
                remainingBinaries.removeAll(applier.getBinaryPatches());
            }
            if (textPatches.isEmpty() && remainingBinaries.isEmpty()) {
                shelveChangesManager.recycleChangeList(this.myCurrentShelveChangeList);
            } else {
                shelveChangesManager.saveRemainingPatches(this.myCurrentShelveChangeList, textPatches, ContainerUtil.mapNotNull((Collection)remainingBinaries, (Function)new Function<FilePatch, ShelvedBinaryFile>(){

                    public ShelvedBinaryFile fun(FilePatch patch) {
                        return patch instanceof ShelvedBinaryFilePatch ? ((ShelvedBinaryFilePatch)patch).getShelvedBinaryFile() : null;
                    }
                }), commitContext);
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't update and store remaining patches", (Throwable)e);
        }
    }
}

