/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class VcsIntegrationEnabler<VcsT extends AbstractVcs> {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VcsT myVcs;

    protected VcsIntegrationEnabler(@NotNull VcsT vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/roots/VcsIntegrationEnabler", "<init>"));
        }
        this.myProject = vcs.getProject();
        this.myVcs = vcs;
    }

    public void enable(@NotNull Collection<VcsRoot> vcsRoots) {
        if (vcsRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoots", "com/intellij/openapi/vcs/roots/VcsIntegrationEnabler", "enable"));
        }
        List vcsFilterRoots = ContainerUtil.filter(vcsRoots, (Condition)new Condition<VcsRoot>(){

            public boolean value(VcsRoot root) {
                AbstractVcs vcs = root.getVcs();
                return vcs != null && vcs.getName().equals(VcsIntegrationEnabler.this.myVcs.getName());
            }
        });
        Collection<VirtualFile> roots = VcsRootErrorsFinder.vcsRootsToVirtualFiles(vcsFilterRoots);
        VirtualFile projectDir = this.myProject.getBaseDir();
        assert (projectDir != null) : "Base dir is unexpectedly null for project: " + this.myProject;
        if (vcsFilterRoots.isEmpty()) {
            boolean succeeded = this.initOrNotifyError(projectDir);
            if (succeeded) {
                this.addVcsRoots(Collections.singleton(projectDir));
            }
        } else {
            assert (!roots.isEmpty());
            if (roots.size() > 1 || this.isProjectBelowVcs(roots)) {
                this.notifyAddedRoots(roots);
            }
            this.addVcsRoots(roots);
        }
    }

    private boolean isProjectBelowVcs(@NotNull Collection<VirtualFile> vcsRoots) {
        if (vcsRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoots", "com/intellij/openapi/vcs/roots/VcsIntegrationEnabler", "isProjectBelowVcs"));
        }
        VirtualFile baseDir = this.myProject.getBaseDir();
        for (VirtualFile root : vcsRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)baseDir, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String joinRootsPaths(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/vcs/roots/VcsIntegrationEnabler", "joinRootsPaths"));
        }
        String string = StringUtil.join(roots, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile virtualFile) {
                return virtualFile.getPresentableUrl();
            }
        }, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsIntegrationEnabler", "joinRootsPaths"));
        }
        return string;
    }

    protected abstract boolean initOrNotifyError(@NotNull VirtualFile var1);

    protected void notifyAddedRoots(Collection<VirtualFile> roots) {
        VcsNotifier notifier = VcsNotifier.getInstance(this.myProject);
        notifier.notifySuccess("", String.format("Added %s %s: %s", this.myVcs.getName(), StringUtil.pluralize((String)"root", (int)roots.size()), VcsIntegrationEnabler.joinRootsPaths(roots)));
    }

    private void addVcsRoots(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/vcs/roots/VcsIntegrationEnabler", "addVcsRoots"));
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        List<VirtualFile> currentVcsRoots = Arrays.asList(vcsManager.getRootsUnderVcs(this.myVcs));
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>(vcsManager.getDirectoryMappings(this.myVcs));
        for (VirtualFile root : roots) {
            if (currentVcsRoots.contains(root)) continue;
            mappings.add(new VcsDirectoryMapping(root.getPath(), this.myVcs.getName()));
        }
        vcsManager.setDirectoryMappings(mappings);
    }

    protected static void refreshVcsDir(final @NotNull VirtualFile projectDir, final @NotNull String vcsDirName) {
        if (projectDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDir", "com/intellij/openapi/vcs/roots/VcsIntegrationEnabler", "refreshVcsDir"));
        }
        if (vcsDirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDirName", "com/intellij/openapi/vcs/roots/VcsIntegrationEnabler", "refreshVcsDir"));
        }
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        LocalFileSystem.getInstance().refreshAndFindFileByPath(projectDir.getPath() + "/" + vcsDirName);
                    }
                });
            }
        });
    }
}

