/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.profile.codeInspection.ui.header.ProfilesComboBox;
import com.intellij.profile.codeInspection.ui.header.SaveInputComponentValidator;
import com.intellij.profile.codeInspection.ui.header.ValidatedTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilesChooser
extends JPanel {
    private static final String COMBO_CARD = "combo.card";
    private static final String EDIT_CARD = "edit.card";
    private final ProfilesComboBox myProfilesComboBox;
    private final CardLayout myCardLayout;
    private final ValidatedTextField mySubmitNameComponent;
    private final SaveInputComponentValidator.Wrapper mySaveListener;
    private final JPanel myComboBoxPanel;
    private final Project myProject;

    public ProfilesChooser(Project project2) {
        this.myProject = project2;
        this.myComboBoxPanel = new JPanel();
        this.myCardLayout = new CardLayout();
        this.myComboBoxPanel.setLayout(this.myCardLayout);
        this.setBorder(IdeBorderFactory.createEmptyBorder((Insets)JBUI.insets((int)4, (int)0, (int)6, (int)0)));
        this.myProfilesComboBox = new ProfilesComboBox(){

            @Override
            protected void onProfileChosen(InspectionProfileImpl inspectionProfile) {
                ProfilesChooser.this.onProfileChosen(inspectionProfile);
            }

            @Override
            protected boolean isProjectLevel(InspectionProfileImpl p) {
                return ProfilesChooser.this.isProjectLevel(p);
            }

            @Override
            @NotNull
            protected String getProfileName(InspectionProfileImpl p) {
                String string = ProfilesChooser.this.getProfileName(p);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/ProfilesChooser$1", "getProfileName"));
                }
                return string;
            }
        };
        this.myComboBoxPanel.add((Component)((Object)this.myProfilesComboBox), COMBO_CARD);
        this.mySaveListener = new SaveInputComponentValidator.Wrapper();
        this.mySubmitNameComponent = new ValidatedTextField(this.mySaveListener);
        this.myComboBoxPanel.add((Component)((Object)this.mySubmitNameComponent), EDIT_CARD);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mySubmitNameComponent.getHintLabel(), "North");
        this.add((Component)this.myComboBoxPanel, "Center");
        this.showComboBoxCard();
    }

    ProfilesComboBox getProfilesComboBox() {
        return this.myProfilesComboBox;
    }

    protected abstract void onProfileChosen(InspectionProfileImpl var1);

    protected abstract boolean isProjectLevel(InspectionProfileImpl var1);

    @NotNull
    protected abstract String getProfileName(InspectionProfileImpl var1);

    void showEditCard(String initialValue, SaveInputComponentValidator inputValidator) {
        this.mySaveListener.setDelegate(inputValidator);
        this.mySubmitNameComponent.setText(initialValue);
        this.myCardLayout.show(this.myComboBoxPanel, EDIT_CARD);
        ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)this.mySubmitNameComponent), true));
    }

    void showComboBoxCard() {
        this.myCardLayout.show(this.myComboBoxPanel, COMBO_CARD);
    }
}

