/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ModifierAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaElementArrangementEntry
extends DefaultArrangementEntry
implements TypeAwareArrangementEntry,
NameAwareArrangementEntry,
ModifierAwareArrangementEntry {
    @NotNull
    private final Set<ArrangementSettingsToken> myModifiers;
    @NotNull
    private final Set<ArrangementSettingsToken> myTypes;
    @NotNull
    private final ArrangementSettingsToken myType;
    @Nullable
    private final String myName;

    public JavaElementArrangementEntry(@Nullable ArrangementEntry parent, @NotNull TextRange range, @NotNull ArrangementSettingsToken type, @Nullable String name, boolean canBeMatched) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/codeStyle/arrangement/JavaElementArrangementEntry", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/codeStyle/arrangement/JavaElementArrangementEntry", "<init>"));
        }
        this(parent, range.getStartOffset(), range.getEndOffset(), type, name, canBeMatched);
    }

    public JavaElementArrangementEntry(@Nullable ArrangementEntry parent, int startOffset, int endOffset, @NotNull ArrangementSettingsToken type, @Nullable String name, boolean canBeArranged) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/codeStyle/arrangement/JavaElementArrangementEntry", "<init>"));
        }
        super(parent, startOffset, endOffset, canBeArranged);
        this.myModifiers = ContainerUtilRt.newHashSet();
        this.myTypes = ContainerUtilRt.newHashSet();
        this.myType = type;
        this.myTypes.add(type);
        this.myName = name;
    }

    @NotNull
    public Set<ArrangementSettingsToken> getModifiers() {
        Set<ArrangementSettingsToken> set = this.myModifiers;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaElementArrangementEntry", "getModifiers"));
        }
        return set;
    }

    public void addModifier(@NotNull ArrangementSettingsToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/psi/codeStyle/arrangement/JavaElementArrangementEntry", "addModifier"));
        }
        this.myModifiers.add(modifier);
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public Set<ArrangementSettingsToken> getTypes() {
        Set<ArrangementSettingsToken> set = this.myTypes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaElementArrangementEntry", "getTypes"));
        }
        return set;
    }

    @NotNull
    public ArrangementSettingsToken getType() {
        ArrangementSettingsToken arrangementSettingsToken = this.myType;
        if (arrangementSettingsToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaElementArrangementEntry", "getType"));
        }
        return arrangementSettingsToken;
    }

    public String toString() {
        return String.format("[%d; %d): %s %s %s", this.getStartOffset(), this.getEndOffset(), StringUtil.join(this.myModifiers, (String)" ").toLowerCase(), this.myTypes.iterator().next().toString().toLowerCase(), this.myName == null ? "<no name>" : this.myName);
    }
}

