/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaJspElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import org.jetbrains.annotations.NotNull;

public class MultipleFieldDeclarationHelper {
    public static boolean compoundFieldPart(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/formatter/java/MultipleFieldDeclarationHelper", "compoundFieldPart"));
        }
        if (node.getElementType() != JavaElementType.FIELD) {
            return false;
        }
        ASTNode firstChild = node.getFirstChildNode();
        if (firstChild == null || firstChild.getElementType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        ASTNode prev = node.getTreePrev();
        return prev == null || !JavaJspElementType.WHITE_SPACE_BIT_SET.contains(prev.getElementType()) || StringUtil.countNewLines((CharSequence)prev.getChars()) <= 1;
    }

    @NotNull
    public static ASTNode findLastFieldInGroup(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/formatter/java/MultipleFieldDeclarationHelper", "findLastFieldInGroup"));
        }
        PsiElement psi = child.getPsi();
        if (psi == null) {
            ASTNode aSTNode = child;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/MultipleFieldDeclarationHelper", "findLastFieldInGroup"));
            }
            return aSTNode;
        }
        PsiTypeElement typeElement = ((PsiVariable)psi).getTypeElement();
        if (typeElement == null) {
            ASTNode aSTNode = child;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/MultipleFieldDeclarationHelper", "findLastFieldInGroup"));
            }
            return aSTNode;
        }
        ASTNode lastChildNode = child.getLastChildNode();
        if (lastChildNode == null) {
            ASTNode aSTNode = child;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/MultipleFieldDeclarationHelper", "findLastFieldInGroup"));
            }
            return aSTNode;
        }
        if (lastChildNode.getElementType() == JavaTokenType.SEMICOLON) {
            ASTNode aSTNode = child;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/MultipleFieldDeclarationHelper", "findLastFieldInGroup"));
            }
            return aSTNode;
        }
        ASTNode currentResult = child;
        for (ASTNode currentNode = child.getTreeNext(); currentNode != null; currentNode = currentNode.getTreeNext()) {
            if (currentNode.getElementType() == TokenType.WHITE_SPACE || currentNode.getElementType() == JavaTokenType.COMMA || StdTokenSets.COMMENT_BIT_SET.contains(currentNode.getElementType())) continue;
            if (currentNode.getElementType() == JavaElementType.FIELD) {
                if (MultipleFieldDeclarationHelper.compoundFieldPart(currentNode)) {
                    currentResult = currentNode;
                    continue;
                }
                ASTNode aSTNode = currentResult;
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/MultipleFieldDeclarationHelper", "findLastFieldInGroup"));
                }
                return aSTNode;
            }
            ASTNode aSTNode = currentResult;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/MultipleFieldDeclarationHelper", "findLastFieldInGroup"));
            }
            return aSTNode;
        }
        ASTNode aSTNode = currentResult;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/MultipleFieldDeclarationHelper", "findLastFieldInGroup"));
        }
        return aSTNode;
    }
}

