/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;

public class PsiParameterStubImpl
extends StubBase<PsiParameter>
implements PsiParameterStub {
    private static final byte ELLIPSIS = 1;
    private static final byte GENERATED_NAME = 2;
    private StringRef myName;
    private final TypeInfo myType;
    private byte myFlags;

    private static byte packFlags(boolean isEllipsis, boolean generatedName) {
        byte flags = 0;
        flags = BitUtil.set((byte)flags, (byte)1, (boolean)isEllipsis);
        flags = BitUtil.set((byte)flags, (byte)2, (boolean)generatedName);
        return flags;
    }

    public PsiParameterStubImpl(StubElement parent, @NotNull String name, @NotNull TypeInfo type, boolean ellipsis, boolean generatedName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        this(parent, StringRef.fromString((String)name), type, PsiParameterStubImpl.packFlags(ellipsis, generatedName));
    }

    public PsiParameterStubImpl(StubElement parent, @NotNull StringRef name, @NotNull TypeInfo type, byte flags) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        super(parent, (IStubElementType)JavaStubElementTypes.PARAMETER);
        this.myName = name;
        this.myType = type;
        this.myFlags = flags;
    }

    @Override
    public boolean isParameterTypeEllipsis() {
        return BitUtil.isSet((byte)this.myFlags, (byte)1);
    }

    @Override
    @NotNull
    public TypeInfo getType(boolean doResolve) {
        TypeInfo typeInfo = doResolve ? this.myType.applyAnnotations(this) : this.myType;
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "getType"));
        }
        return typeInfo;
    }

    @Override
    public PsiModifierListStub getModList() {
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiModifierListStub)) continue;
            return (PsiModifierListStub)child;
        }
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = StringRef.toString((StringRef)this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "getName"));
        }
        return string;
    }

    public void setName(String name) {
        this.myName = StringRef.fromString((String)name);
        this.myFlags = BitUtil.set((byte)this.myFlags, (byte)2, (boolean)false);
    }

    public boolean isAutoGeneratedName() {
        return BitUtil.isSet((byte)this.myFlags, (byte)2);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    public String toString() {
        return "PsiParameterStub[" + this.myName + ':' + this.myType + ']';
    }
}

