/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.migration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.migration.MigrationClassImpl;
import com.intellij.psi.impl.migration.MigrationPackageImpl;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PsiMigrationImpl
implements PsiMigration {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.migration.PsiMigrationImpl");
    private final PsiMigrationManager myMigrationManager;
    private final JavaPsiFacade myFacade;
    private final PsiManagerImpl myManager;
    private final Map<String, MigrationClassImpl> myQNameToClassMap = new HashMap();
    private final Map<String, List<PsiClass>> myPackageToClassesMap = new HashMap();
    private final Map<String, MigrationPackageImpl> myQNameToPackageMap = new HashMap();
    private final Map<String, List<PsiPackage>> myPackageToSubpackagesMap = new HashMap();
    private boolean myIsValid = true;

    public PsiMigrationImpl(PsiMigrationManager migrationManager, JavaPsiFacade facade, PsiManagerImpl manager) {
        this.myMigrationManager = migrationManager;
        this.myFacade = facade;
        this.myManager = manager;
    }

    public PsiClass createClass(String qualifiedName) {
        this.assertValid();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        MigrationClassImpl migrationClass = new MigrationClassImpl(this, qualifiedName);
        MigrationClassImpl oldMigrationClass = this.myQNameToClassMap.put(qualifiedName, migrationClass);
        LOG.assertTrue(oldMigrationClass == null, (Object)qualifiedName);
        String packageName = PsiMigrationImpl.parentPackageName(qualifiedName);
        PsiPackage aPackage = this.myFacade.findPackage(packageName);
        if (aPackage == null) {
            this.createPackage(packageName);
        }
        List<PsiClass> psiClasses = this.getClassesList(packageName);
        psiClasses.add(migrationClass);
        this.myMigrationManager.migrationModified(false);
        return migrationClass;
    }

    private List<PsiClass> getClassesList(String packageName) {
        this.assertValid();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List<PsiClass> psiClasses = this.myPackageToClassesMap.get(packageName);
        if (psiClasses == null) {
            psiClasses = new ArrayList<PsiClass>();
            this.myPackageToClassesMap.put(packageName, psiClasses);
        }
        return psiClasses;
    }

    public PsiPackage createPackage(String qualifiedName) {
        this.assertValid();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        MigrationPackageImpl migrationPackage = new MigrationPackageImpl(this, qualifiedName);
        MigrationPackageImpl oldMigrationPackage = this.myQNameToPackageMap.put(qualifiedName, migrationPackage);
        LOG.assertTrue(oldMigrationPackage == null, (Object)qualifiedName);
        String parentName = PsiMigrationImpl.parentPackageName(qualifiedName);
        PsiPackage aPackage = this.myFacade.findPackage(parentName);
        if (aPackage == null) {
            this.createPackage(parentName);
        }
        List<PsiPackage> psiPackages = this.getSubpackagesList(parentName);
        psiPackages.add(migrationPackage);
        this.myMigrationManager.migrationModified(false);
        return migrationPackage;
    }

    public void finish() {
        this.assertValid();
        this.myQNameToClassMap.clear();
        this.myQNameToPackageMap.clear();
        this.myPackageToClassesMap.clear();
        this.myPackageToSubpackagesMap.clear();
        this.myIsValid = false;
        this.myMigrationManager.migrationModified(true);
    }

    private void assertValid() {
        LOG.assertTrue(this.myIsValid);
    }

    private List<PsiPackage> getSubpackagesList(String parentName) {
        this.assertValid();
        List<PsiPackage> psiPackages = this.myPackageToSubpackagesMap.get(parentName);
        if (psiPackages == null) {
            psiPackages = new ArrayList<PsiPackage>();
            this.myPackageToSubpackagesMap.put(parentName, psiPackages);
        }
        return psiPackages;
    }

    public List<PsiClass> getMigrationClasses(String packageName) {
        this.assertValid();
        return this.getClassesList(packageName);
    }

    public List<PsiPackage> getMigrationPackages(String packageName) {
        this.assertValid();
        return this.getSubpackagesList(packageName);
    }

    public PsiClass getMigrationClass(String qualifiedName) {
        this.assertValid();
        return this.myQNameToClassMap.get(qualifiedName);
    }

    public PsiPackage getMigrationPackage(String qualifiedName) {
        this.assertValid();
        return this.myQNameToPackageMap.get(qualifiedName);
    }

    private static String parentPackageName(String qualifiedName) {
        int lastDotIndex = qualifiedName.lastIndexOf(46);
        return lastDotIndex >= 0 ? qualifiedName.substring(0, lastDotIndex) : "";
    }

    PsiManagerImpl getManager() {
        return this.myManager;
    }

    boolean isValid() {
        return this.myIsValid;
    }
}

