/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.ConstructorReferencesSearchHelper;
import com.intellij.psi.impl.search.MethodTextOccurrenceProcessor;
import com.intellij.psi.impl.search.PsiAnnotationMethodReferencesSearcher;
import com.intellij.psi.impl.search.SimpleAccessorReferenceSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class MethodUsagesSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/MethodUsagesSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/MethodUsagesSearcher", "processQuery"));
        }
        final PsiMethod method = p.getMethod();
        boolean[] isConstructor = new boolean[1];
        PsiManager[] psiManager = new PsiManager[1];
        final String[] methodName = new String[1];
        boolean[] isValueAnnotation = new boolean[1];
        boolean[] needStrictSignatureSearch = new boolean[1];
        final boolean strictSignatureSearch = p.isStrictSignatureSearch();
        final PsiClass aClass = (PsiClass)MethodUsagesSearcher.resolveInReadAction(p.getProject(), () -> {
            PsiClass aClass1 = method.getContainingClass();
            if (aClass1 == null) {
                return null;
            }
            isConstructor[0] = method.isConstructor();
            psiManager[0] = aClass1.getManager();
            methodName[0] = method.getName();
            isValueAnnotation[0] = PsiUtil.isAnnotationMethod((PsiElement)method) && "value".equals(methodName[0]) && method.getParameterList().getParametersCount() == 0;
            needStrictSignatureSearch[0] = strictSignatureSearch && (aClass1 instanceof PsiAnonymousClass || aClass1.hasModifierProperty("final") || method.hasModifierProperty("static") || method.hasModifierProperty("final") || method.hasModifierProperty("private"));
            return aClass1;
        });
        if (aClass == null) {
            return;
        }
        final SearchRequestCollector collector = p.getOptimizer();
        final SearchScope searchScope = (SearchScope)MethodUsagesSearcher.resolveInReadAction(p.getProject(), () -> {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/MethodUsagesSearcher", "lambda$processQuery$1"));
            }
            return p.getEffectiveSearchScope();
        });
        if (searchScope == GlobalSearchScope.EMPTY_SCOPE) {
            return;
        }
        if (isConstructor[0]) {
            new ConstructorReferencesSearchHelper(psiManager[0]).processConstructorReferences(consumer, method, aClass, searchScope, p.getProject(), false, strictSignatureSearch, collector);
        }
        if (isValueAnnotation[0]) {
            ReadActionProcessor<PsiReference> refProcessor = PsiAnnotationMethodReferencesSearcher.createImplicitDefaultAnnotationMethodConsumer(consumer);
            ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope).forEach(refProcessor);
        }
        if (needStrictSignatureSearch[0]) {
            ReferencesSearch.searchOptimized((PsiElement)method, (SearchScope)searchScope, (boolean)false, (SearchRequestCollector)collector, consumer);
            return;
        }
        if (StringUtil.isEmpty((String)methodName[0])) {
            return;
        }
        MethodUsagesSearcher.resolveInReadAction(p.getProject(), new Computable<Void>(){

            public Void compute() {
                PsiMethod[] psiMethodArray;
                if (strictSignatureSearch) {
                    PsiMethod[] psiMethodArray2 = new PsiMethod[1];
                    psiMethodArray = psiMethodArray2;
                    psiMethodArray2[0] = method;
                } else {
                    psiMethodArray = aClass.findMethodsByName(methodName[0], false);
                }
                PsiMethod[] methods = psiMethodArray;
                SearchScope accessScope = methods[0].getUseScope();
                for (int i = 1; i < methods.length; ++i) {
                    PsiMethod method1 = methods[i];
                    accessScope = accessScope.union(method1.getUseScope());
                }
                SearchScope restrictedByAccessScope = searchScope.intersectWith(accessScope);
                short searchContext = 11;
                collector.searchWord(methodName[0], restrictedByAccessScope, searchContext, true, (PsiElement)method, (RequestResultProcessor)MethodUsagesSearcher.this.getTextOccurrenceProcessor(methods, aClass, strictSignatureSearch));
                SimpleAccessorReferenceSearcher.addPropertyAccessUsages(method, restrictedByAccessScope, collector);
                return null;
            }
        });
    }

    static <T> T resolveInReadAction(@NotNull Project p, @NotNull Computable<T> computable) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/MethodUsagesSearcher", "resolveInReadAction"));
        }
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/psi/impl/search/MethodUsagesSearcher", "resolveInReadAction"));
        }
        return (T)(ApplicationManager.getApplication().isReadAccessAllowed() ? computable.compute() : DumbService.getInstance((Project)p).runReadActionInSmartMode(computable));
    }

    protected MethodTextOccurrenceProcessor getTextOccurrenceProcessor(PsiMethod[] methods, PsiClass aClass, boolean strictSignatureSearch) {
        return new MethodTextOccurrenceProcessor(aClass, strictSignatureSearch, methods);
    }
}

