/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.options.LazySchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeDataHolder;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleSchemesImpl
extends CodeStyleSchemes {
    protected static final String DEFAULT_SCHEME_NAME = "Default";
    @NonNls
    static final String CODE_STYLES_DIR_PATH = "codestyles";
    protected final SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> mySchemeManager;

    public CodeStyleSchemesImpl(@NotNull SchemesManagerFactory schemesManagerFactory) {
        if (schemesManagerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesManagerFactory", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "<init>"));
        }
        this.mySchemeManager = schemesManagerFactory.create(CODE_STYLES_DIR_PATH, (SchemeProcessor)new LazySchemeProcessor<CodeStyleSchemeImpl>(){

            @Override
            @NotNull
            public CodeStyleSchemeImpl createScheme(@NotNull SchemeDataHolder dataHolder, @NotNull Function<String, String> attributeProvider, boolean duringLoad) {
                if (dataHolder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "createScheme"));
                }
                if (attributeProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeProvider", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "createScheme"));
                }
                CodeStyleSchemeImpl codeStyleSchemeImpl = new CodeStyleSchemeImpl(attributeProvider.apply("name"), attributeProvider.apply("parent"), dataHolder);
                if (codeStyleSchemeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "createScheme"));
                }
                return codeStyleSchemeImpl;
            }

            public Element writeScheme(@NotNull CodeStyleSchemeImpl scheme) throws WriteExternalException {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "writeScheme"));
                }
                return scheme.writeScheme();
            }

            @NotNull
            public SchemeProcessor.State getState(@NotNull CodeStyleSchemeImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "getState"));
                }
                if (scheme.isDefault()) {
                    SchemeProcessor.State state = SchemeProcessor.State.NON_PERSISTENT;
                    if (state == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "getState"));
                    }
                    return state;
                }
                SchemeProcessor.State state = scheme.isInitialized() ? SchemeProcessor.State.POSSIBLY_CHANGED : SchemeProcessor.State.UNCHANGED;
                if (state == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "getState"));
                }
                return state;
            }
        });
        this.mySchemeManager.loadSchemes();
        this.addScheme(new CodeStyleSchemeImpl(DEFAULT_SCHEME_NAME, true, null));
        this.setCurrentScheme(this.getDefaultScheme());
    }

    public CodeStyleScheme getCurrentScheme() {
        return (CodeStyleScheme)this.mySchemeManager.getCurrentScheme();
    }

    public void setCurrentScheme(CodeStyleScheme scheme) {
        this.mySchemeManager.setCurrent((Scheme)scheme);
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        String name;
        if (preferredName == null) {
            if (parentScheme == null) {
                throw new IllegalArgumentException("parentScheme must not be null");
            }
            name = null;
            int i = 1;
            while (name == null) {
                String currName = parentScheme.getName() + " (" + i + ")";
                if (this.mySchemeManager.findSchemeByName(currName) == null) {
                    name = currName;
                }
                ++i;
            }
        } else {
            name = null;
            int i = 0;
            while (name == null) {
                String currName;
                String string = currName = i == 0 ? preferredName : preferredName + " (" + i + ")";
                if (this.mySchemeManager.findSchemeByName(currName) == null) {
                    name = currName;
                }
                ++i;
            }
        }
        return new CodeStyleSchemeImpl(name, false, parentScheme);
    }

    public void deleteScheme(CodeStyleScheme scheme) {
        if (scheme.isDefault()) {
            throw new IllegalArgumentException("Unable to delete default scheme!");
        }
        CodeStyleSchemeImpl currScheme = (CodeStyleSchemeImpl)this.getCurrentScheme();
        if (currScheme == scheme) {
            CodeStyleScheme newCurrentScheme = this.getDefaultScheme();
            if (newCurrentScheme == null) {
                throw new IllegalStateException("Unable to load default scheme!");
            }
            this.setCurrentScheme(newCurrentScheme);
        }
        this.mySchemeManager.removeScheme((Scheme)scheme);
    }

    public CodeStyleScheme getDefaultScheme() {
        return (CodeStyleScheme)this.mySchemeManager.findSchemeByName(DEFAULT_SCHEME_NAME);
    }

    @Nullable
    public CodeStyleScheme findSchemeByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "findSchemeByName"));
        }
        return (CodeStyleScheme)this.mySchemeManager.findSchemeByName(name);
    }

    public void addScheme(@NotNull CodeStyleScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "addScheme"));
        }
        this.mySchemeManager.addScheme((Scheme)scheme);
    }

    @NotNull
    public static SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> getSchemeManager() {
        SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> schemesManager = ((CodeStyleSchemesImpl)CodeStyleSchemes.getInstance()).mySchemeManager;
        if (schemesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "getSchemeManager"));
        }
        return schemesManager;
    }
}

