/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeCompatibilityConstraint
implements ConstraintFormula {
    private PsiType myT;
    private PsiType myS;

    public TypeCompatibilityConstraint(@NotNull PsiType t, @NotNull PsiType s) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeCompatibilityConstraint", "<init>"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeCompatibilityConstraint", "<init>"));
        }
        this.myT = t;
        this.myS = s;
    }

    @Override
    public boolean reduce(InferenceSession session2, List<ConstraintFormula> constraints) {
        PsiClassType boxedType;
        if (session2.isProperType(this.myT) && session2.isProperType(this.myS)) {
            boolean assignable = TypeConversionUtil.isAssignable((PsiType)this.myT, (PsiType)this.myS);
            if (!assignable) {
                session2.registerIncompatibleErrorMessage("Incompatible types: " + session2.getPresentableText(this.myS) + " is not convertible to " + session2.getPresentableText(this.myT));
            }
            return assignable;
        }
        if (this.myS instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)this.myS) && (boxedType = ((PsiPrimitiveType)this.myS).getBoxedType(session2.getManager(), session2.getScope())) != null) {
            constraints.add(new TypeCompatibilityConstraint(this.myT, (PsiType)boxedType));
            return true;
        }
        if (this.myT instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)this.myT) && (boxedType = ((PsiPrimitiveType)this.myT).getBoxedType(session2.getManager(), session2.getScope())) != null) {
            constraints.add(new TypeEqualityConstraint((PsiType)boxedType, this.myS));
            return true;
        }
        if (TypeCompatibilityConstraint.isUncheckedConversion(this.myT, this.myS)) {
            session2.setErased();
            return true;
        }
        constraints.add(new StrictSubtypingConstraint(this.myT, this.myS));
        return true;
    }

    public static boolean isUncheckedConversion(PsiType t, PsiType s) {
        if (t instanceof PsiClassType && !((PsiClassType)t).isRaw() && s instanceof PsiClassType) {
            PsiSubstitutor sSubstitutor;
            PsiClassType.ClassResolveResult tResult = ((PsiClassType)t).resolveGenerics();
            PsiClassType.ClassResolveResult sResult = ((PsiClassType)s).resolveGenerics();
            PsiClass tClass = tResult.getElement();
            PsiClass sClass = sResult.getElement();
            if (tClass != null && sClass != null && !(sClass instanceof InferenceVariable) && ((sSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)tClass, (PsiClass)sClass, (PsiSubstitutor)sResult.getSubstitutor())) != null ? PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)tClass, (PsiSubstitutor)sSubstitutor) : tClass instanceof InferenceVariable && ((PsiClassType)s).isRaw() && tClass.isInheritor(sClass, true))) {
                return true;
            }
        } else if (t instanceof PsiArrayType && t.getArrayDimensions() == s.getArrayDimensions()) {
            return TypeCompatibilityConstraint.isUncheckedConversion(t.getDeepComponentType(), s.getDeepComponentType());
        }
        return false;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
        this.myS = substitutor.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeCompatibilityConstraint that = (TypeCompatibilityConstraint)o;
        if (!this.myS.equals(that.myS)) {
            return false;
        }
        return this.myT.equals(that.myT);
    }

    public int hashCode() {
        int result2 = this.myT.hashCode();
        result2 = 31 * result2 + this.myS.hashCode();
        return result2;
    }

    public String toString() {
        return this.myS.getPresentableText() + " -> " + this.myT.getPresentableText();
    }
}

