/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.pom.xml.impl.events.XmlAttributeSetImpl;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.XmlAttributeReference;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeImpl
extends XmlElementImpl
implements XmlAttribute,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlAttributeImpl");
    private final int myHC = ourHC++;
    private volatile String myDisplayText;
    private volatile int[] myGapDisplayStarts;
    private volatile int[] myGapPhysicalStarts;
    private volatile TextRange myValueTextRange;

    public final int hashCode() {
        return this.myHC;
    }

    public XmlAttributeImpl() {
        super(XmlElementType.XML_ATTRIBUTE);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == XmlTokenType.XML_NAME) {
            return 229;
        }
        if (i == XmlElementType.XML_ATTRIBUTE_VALUE) {
            return 243;
        }
        return 0;
    }

    public XmlAttributeValue getValueElement() {
        return (XmlAttributeValue)XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this);
    }

    public void setValue(String valueText) throws IncorrectOperationException {
        final ASTNode value = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this);
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAttribute attribute = XmlElementFactory.getInstance((Project)this.getProject()).createAttribute("a", valueText, (PsiElement)this);
        final ASTNode newValue = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild((ASTNode)attribute);
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

            public PomModelEvent runInner() {
                XmlAttributeImpl att = XmlAttributeImpl.this;
                if (value != null) {
                    if (newValue != null) {
                        att.replaceChild(value, newValue.copyElement());
                    } else {
                        att.removeChild(value);
                    }
                } else if (newValue != null) {
                    att.addChild(newValue.getTreePrev().copyElement());
                    att.addChild(newValue.copyElement());
                }
                return XmlAttributeSetImpl.createXmlAttributeSet(model, XmlAttributeImpl.this.getParent(), XmlAttributeImpl.this.getName(), newValue != null ? newValue.getText() : null);
            }
        });
    }

    public XmlElement getNameElement() {
        return (XmlElement)XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this);
    }

    @NotNull
    public String getNamespace() {
        String name = this.getName();
        String prefixByQualifiedName = XmlUtil.findPrefixByQualifiedName(name);
        if (prefixByQualifiedName.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "getNamespace"));
            }
            return "";
        }
        String string = this.getParent().getNamespaceByPrefix(prefixByQualifiedName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "getNamespace"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getNamespacePrefix() {
        String string = XmlUtil.findPrefixByQualifiedName(this.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "getNamespacePrefix"));
        }
        return string;
    }

    public XmlTag getParent() {
        PsiElement parentTag = super.getParent();
        return parentTag instanceof XmlTag ? (XmlTag)parentTag : null;
    }

    @NotNull
    public String getLocalName() {
        String string = XmlUtil.findLocalNameByQualifiedName(this.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "getLocalName"));
        }
        return string;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "accept"));
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttribute((XmlAttribute)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getValue() {
        XmlAttributeValue valueElement = this.getValueElement();
        return valueElement != null ? valueElement.getValue() : null;
    }

    protected void appendChildToDisplayValue(StringBuilder buffer, ASTNode child) {
        buffer.append(child.getChars());
    }

    public String getDisplayValue() {
        String displayText = this.myDisplayText;
        if (displayText != null) {
            return displayText;
        }
        XmlAttributeValue value = this.getValueElement();
        if (value == null) {
            return null;
        }
        PsiElement firstChild = value.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        ASTNode child = firstChild.getNode();
        TextRange valueTextRange = new TextRange(0, value.getTextLength());
        if (child != null && child.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            valueTextRange = new TextRange(child.getTextLength(), valueTextRange.getEndOffset());
            child = child.getTreeNext();
        }
        TIntArrayList gapsStarts = new TIntArrayList();
        TIntArrayList gapsShifts = new TIntArrayList();
        StringBuilder buffer = new StringBuilder(this.getTextLength());
        while (child != null) {
            int start = buffer.length();
            IElementType elementType = child.getElementType();
            if (elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                valueTextRange = new TextRange(valueTextRange.getStartOffset(), child.getTextRange().getStartOffset() - value.getTextRange().getStartOffset());
                break;
            }
            if (elementType == XmlTokenType.XML_CHAR_ENTITY_REF) {
                buffer.append(XmlUtil.getCharFromEntityRef(child.getText()));
            } else if (elementType == XmlElementType.XML_ENTITY_REF) {
                buffer.append(XmlUtil.getEntityValue((XmlEntityRef)child));
            } else {
                this.appendChildToDisplayValue(buffer, child);
            }
            int end = buffer.length();
            int originalLength = child.getTextLength();
            if (end - start != originalLength) {
                gapsStarts.add(start);
                gapsShifts.add(originalLength - (end - start));
            }
            child = child.getTreeNext();
        }
        int[] gapDisplayStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int[] gapPhysicalStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int currentGapsSum = 0;
        for (int i = 0; i < gapDisplayStarts.length; ++i) {
            gapDisplayStarts[i] = gapsStarts.get(i);
            gapPhysicalStarts[i] = gapDisplayStarts[i] + (currentGapsSum += gapsShifts.get(i));
        }
        this.myGapDisplayStarts = gapDisplayStarts;
        this.myGapPhysicalStarts = gapPhysicalStarts;
        this.myValueTextRange = valueTextRange;
        this.myDisplayText = buffer.toString();
        return this.myDisplayText;
    }

    public int physicalToDisplay(int physicalIndex) {
        this.getDisplayValue();
        if (physicalIndex < 0 || physicalIndex > this.myValueTextRange.getLength()) {
            return -1;
        }
        if (this.myGapPhysicalStarts.length == 0) {
            return physicalIndex;
        }
        int bsResult = Arrays.binarySearch(this.myGapPhysicalStarts, physicalIndex);
        int gapIndex = bsResult > 0 ? bsResult : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return physicalIndex;
        }
        int shift = this.myGapPhysicalStarts[gapIndex] - this.myGapDisplayStarts[gapIndex];
        return Math.max(this.myGapDisplayStarts[gapIndex], physicalIndex - shift);
    }

    public int displayToPhysical(int displayIndex) {
        String displayValue = this.getDisplayValue();
        if (displayValue == null || displayIndex < 0 || displayIndex > displayValue.length()) {
            return -1;
        }
        if (this.myGapDisplayStarts.length == 0) {
            return displayIndex;
        }
        int bsResult = Arrays.binarySearch(this.myGapDisplayStarts, displayIndex);
        int gapIndex = bsResult > 0 ? bsResult - 1 : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return displayIndex;
        }
        int shift = this.myGapPhysicalStarts[gapIndex] - this.myGapDisplayStarts[gapIndex];
        return displayIndex + shift;
    }

    @NotNull
    public TextRange getValueTextRange() {
        this.getDisplayValue();
        TextRange textRange = this.myValueTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "getValueTextRange"));
        }
        return textRange;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myDisplayText = null;
        this.myGapDisplayStarts = null;
        this.myGapPhysicalStarts = null;
        this.myValueTextRange = null;
    }

    @Override
    @NotNull
    public String getName() {
        XmlElement element = this.getNameElement();
        String string = element != null ? element.getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "getName"));
        }
        return string;
    }

    public boolean isNamespaceDeclaration() {
        String name = this.getName();
        return name.startsWith("xmlns:") || name.equals("xmlns");
    }

    public PsiElement setName(final @NotNull String nameText) throws IncorrectOperationException {
        if (nameText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameText", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "setName"));
        }
        final ASTNode name = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this);
        final String oldName = name.getText();
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAttribute attribute = XmlElementFactory.getInstance((Project)this.getProject()).createAttribute(nameText, "", (PsiElement)this);
        final ASTNode newName = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild((ASTNode)attribute);
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        model.runTransaction((PomTransaction)new PomTransactionBase((PsiElement)this.getParent(), (PomModelAspect)aspect){

            public PomModelEvent runInner() {
                PomModelEvent event = new PomModelEvent(model);
                PsiFile file2 = XmlAttributeImpl.this.getContainingFile();
                XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(model, file2 instanceof XmlFile ? (XmlFile)file2 : null);
                xmlAspectChangeSet.add((XmlChange)new XmlAttributeSetImpl(XmlAttributeImpl.this.getParent(), oldName, null));
                xmlAspectChangeSet.add((XmlChange)new XmlAttributeSetImpl(XmlAttributeImpl.this.getParent(), nameText, XmlAttributeImpl.this.getValue()));
                event.registerChangeSet(model.getModelAspect(XmlAspect.class), (PomChangeSet)xmlAspectChangeSet);
                CodeEditUtil.replaceChild(XmlAttributeImpl.this, name, newName);
                return event;
            }
        });
        return this;
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "shouldAskParentForReferences"));
        }
        return false;
    }

    @Override
    @Deprecated
    @NotNull
    public final PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull PsiReferenceService.Hints hints) {
        PsiReference[] refs;
        XmlElement nameElement;
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "getReferences"));
        }
        if (hints.offsetInElement != null && ((nameElement = this.getNameElement()) == null || hints.offsetInElement > nameElement.getStartOffsetInParent() + nameElement.getTextLength())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] referencesFromProviders = ReferenceProvidersRegistry.getReferencesFromProviders(this);
        if (this.isNamespaceDeclaration()) {
            refs = new PsiReference[referencesFromProviders.length + 1];
            String localName = this.getLocalName();
            String prefix = XmlUtil.findPrefixByQualifiedName(this.getName());
            TextRange range = prefix.isEmpty() ? TextRange.from((int)this.getName().length(), (int)0) : TextRange.from((int)(prefix.length() + 1), (int)localName.length());
            refs[0] = new SchemaPrefixReference(this, range, localName, null);
        } else {
            String prefix = this.getNamespacePrefix();
            if (!prefix.isEmpty() && !this.getLocalName().isEmpty()) {
                refs = new PsiReference[referencesFromProviders.length + 2];
                refs[0] = new SchemaPrefixReference(this, TextRange.from((int)0, (int)prefix.length()), prefix, null);
                refs[1] = new XmlAttributeReference(this);
            } else {
                refs = new PsiReference[referencesFromProviders.length + 1];
                refs[0] = new XmlAttributeReference(this);
            }
        }
        System.arraycopy(referencesFromProviders, 0, refs, refs.length - referencesFromProviders.length, referencesFromProviders.length);
        if (refs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeImpl", "getReferences"));
        }
        return refs;
    }

    @Nullable
    public XmlAttributeDescriptor getDescriptor() {
        XmlTag parentElement = this.getParent();
        if (parentElement == null) {
            return null;
        }
        XmlTag tag = parentElement;
        XmlElementDescriptor descr = tag.getDescriptor();
        if (descr == null) {
            return null;
        }
        XmlAttributeDescriptor attributeDescr = descr.getAttributeDescriptor((XmlAttribute)this);
        return attributeDescr == null ? descr.getAttributeDescriptor(this.getName(), tag) : attributeDescr;
    }

    public String getRealLocalName() {
        String name = this.getLocalName();
        return name.endsWith("IntellijIdeaRulezzz") ? name.substring(0, name.length() - "IntellijIdeaRulezzz".length()) : name;
    }
}

