/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl.test;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.stubsHierarchy.impl.test.InheritanceAction;
import org.jetbrains.annotations.NotNull;

public class GetAllInheritorsAction
extends InheritanceAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubsHierarchy.LogSubtypesAction");

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        PsiClass psiClass = GetAllInheritorsAction.getTarget(dataContext);
        if (psiClass != null) {
            LOG.info("STARTED Inheritors: " + psiClass.getQualifiedName());
            SearchScope scope = psiClass.getUseScope();
            int[] count = new int[]{0};
            ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach(psiClass1 -> {
                count[0] = count[0] + 1;
                return true;
            });
            LOG.info("FINISHED Inheritors. Found: " + count[0]);
        }
    }

    private static PsiClass getTarget(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/psi/stubsHierarchy/impl/test/GetAllInheritorsAction", "getTarget"));
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return null;
            }
            PsiElement targetElement = TargetElementUtilBase.findTargetElement(editor, 11);
            if (targetElement instanceof PsiClass) {
                return (PsiClass)targetElement;
            }
            int offset = editor.getCaretModel().getOffset();
            for (PsiElement element = file2.findElementAt(offset); element != null; element = element.getParent()) {
                if (element instanceof PsiFile) {
                    if (!(element instanceof PsiClassOwner)) {
                        return null;
                    }
                    PsiClass[] classes = ((PsiClassOwner)element).getClasses();
                    return classes.length == 1 ? classes[0] : null;
                }
                if (!(element instanceof PsiClass) || element instanceof PsiAnonymousClass || element instanceof PsiSyntheticClass) continue;
                return (PsiClass)element;
            }
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return element instanceof PsiClass ? (PsiClass)element : null;
    }
}

