/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.stubs;

import com.intellij.psi.stubsHierarchy.stubs.Import;

public abstract class UnitInfo {
    private static final UnitInfo[] EMPTY_INFOS = new UnitInfo[]{new LongUnitInfo(0, Import.EMPTY_ARRAY), new LongUnitInfo(1, Import.EMPTY_ARRAY), new LongUnitInfo(2, Import.EMPTY_ARRAY)};

    static UnitInfo mkUnitInfo(byte unitType, long[] imports) {
        if (imports.length == 0) {
            return EMPTY_INFOS[unitType];
        }
        for (long anImport : imports) {
            if (Import.getAlias(anImport) == 0) continue;
            return new LongUnitInfo(unitType, imports);
        }
        return new IntUnitInfo(unitType, imports);
    }

    public abstract byte getType();

    public abstract long[] getImports();

    static class IntUnitInfo
    extends UnitInfo {
        public final byte type;
        private int[] imports;

        @Override
        public byte getType() {
            return this.type;
        }

        @Override
        public long[] getImports() {
            return IntUnitInfo.convert(this.imports);
        }

        public IntUnitInfo(byte type, long[] imports) {
            this.type = type;
            this.imports = IntUnitInfo.convert(imports);
        }

        private static int[] convert(long[] ar) {
            int[] result2 = new int[ar.length];
            for (int i = 0; i < ar.length; ++i) {
                result2[i] = (int)ar[i];
            }
            return result2;
        }

        private static long[] convert(int[] ar) {
            long[] result2 = new long[ar.length];
            for (int i = 0; i < ar.length; ++i) {
                result2[i] = ar[i];
            }
            return result2;
        }
    }

    static class LongUnitInfo
    extends UnitInfo {
        public final byte type;
        private long[] imports;

        @Override
        public byte getType() {
            return this.type;
        }

        @Override
        public long[] getImports() {
            return this.imports;
        }

        public LongUnitInfo(byte type, long[] imports) {
            this.type = type;
            this.imports = imports;
        }
    }
}

