/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class JavaThrownExceptionInfo
implements ThrownExceptionInfo {
    private final int oldIndex;
    private CanonicalTypes.Type myType;

    public JavaThrownExceptionInfo() {
        this.oldIndex = -1;
    }

    public JavaThrownExceptionInfo(int oldIndex) {
        this.oldIndex = oldIndex;
    }

    public JavaThrownExceptionInfo(int oldIndex, PsiClassType type) {
        this.oldIndex = oldIndex;
        this.setType(type);
    }

    public static ThrownExceptionInfo[] extractExceptions(PsiMethod method) {
        PsiClassType[] types = method.getThrowsList().getReferencedTypes();
        ThrownExceptionInfo[] result2 = new ThrownExceptionInfo[types.length];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = new JavaThrownExceptionInfo(i, types[i]);
        }
        return result2;
    }

    @Override
    public void setType(PsiClassType type) {
        this.myType = CanonicalTypes.createTypeWrapper((PsiType)type);
    }

    @Override
    @Nullable
    public PsiType createType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
        if (this.myType != null) {
            return this.myType.getType(context, manager);
        }
        return null;
    }

    @Override
    public void updateFromMethod(PsiMethod method) {
        if (this.myType != null) {
            return;
        }
        PsiClassType[] types = method.getThrowsList().getReferencedTypes();
        if (this.oldIndex >= 0) {
            this.setType(types[this.oldIndex]);
        }
    }

    @Override
    public int getOldIndex() {
        return this.oldIndex;
    }
}

