/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class MakeMethodDelegate
extends FixableUsageInfo {
    private final PsiMethod method;
    private final String delegate;

    public MakeMethodDelegate(PsiMethod method, String delegate) {
        super((PsiElement)method);
        this.method = method;
        this.delegate = delegate;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiStatement[] statements;
        PsiCodeBlock body = this.method.getBody();
        assert (body != null);
        for (PsiStatement statement2 : statements = body.getStatements()) {
            statement2.delete();
        }
        StringBuffer delegation = new StringBuffer();
        PsiType returnType = this.method.getReturnType();
        if (!PsiType.VOID.equals((Object)returnType)) {
            delegation.append("return ");
        }
        String methodName = this.method.getName();
        delegation.append(this.delegate + '.' + methodName + '(');
        PsiParameterList parameterList = this.method.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        boolean first = true;
        for (PsiParameter parameter : parameters) {
            if (!first) {
                delegation.append(',');
            }
            first = false;
            String parameterName = parameter.getName();
            delegation.append(parameterName);
        }
        delegation.append(");");
        PsiManager manager = this.method.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String delegationText = delegation.toString();
        PsiStatement delegationStatement = factory.createStatementFromText(delegationText, (PsiElement)body);
        body.add((PsiElement)delegationStatement);
    }
}

