/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;

public class InfoDialog
extends DialogWrapper {
    private JCheckBox myShowInFutureCheckBox;
    private JTextArea myTextArea;
    private final String myText;
    private boolean isToShowInFuture;

    public InfoDialog(String text, Project project2) {
        super(project2, false);
        this.myText = text;
        this.setButtonsAlignment(0);
        this.setTitle(RefactoringBundle.message((String)"information.title"));
        this.setButtonsMargin(null);
        this.init();
        this.setOKButtonText(RefactoringBundle.message((String)"ok.button"));
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/InfoDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new BorderLayout());
        JPanel cbPanel = new JPanel(new BorderLayout());
        cbPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.myShowInFutureCheckBox = new JCheckBox();
        this.myShowInFutureCheckBox.setText(RefactoringBundle.message((String)"do.not.show.this.message.in.the.future"));
        panel.add((Component)cbPanel, "South");
        cbPanel.add((Component)this.myShowInFutureCheckBox, "West");
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        panel.add((Component)textPanel, "Center");
        this.myTextArea = new JTextArea(this.myText);
        textPanel.add((Component)this.myTextArea, "Center");
        this.myTextArea.setEditable(false);
        this.myTextArea.setBackground(UIUtil.getPanelBackground());
        Font font = this.myShowInFutureCheckBox.getFont();
        font = new Font(font.getName(), font.getStyle(), font.getSize() + 1);
        this.myTextArea.setFont(font);
        this.myShowInFutureCheckBox.setFont(font);
        this.isToShowInFuture = true;
        this.myShowInFutureCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InfoDialog.this.isToShowInFuture = !InfoDialog.this.myShowInFutureCheckBox.isSelected();
            }
        });
        return panel;
    }

    public boolean isToShowInFuture() {
        return this.isToShowInFuture;
    }
}

