/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringHierarchyUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.RefactoringHierarchyUtil");
    private static final List<? extends PsiType> PRIMITIVE_TYPES = Arrays.asList(PsiType.BYTE, PsiType.CHAR, PsiType.SHORT, PsiType.INT, PsiType.LONG, PsiType.FLOAT, PsiType.DOUBLE);

    private RefactoringHierarchyUtil() {
    }

    public static boolean willBeInTargetClass(PsiElement place, @NotNull Set<? extends PsiMember> membersToMove, @Nullable PsiClass targetClass, boolean includeSubclasses) {
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersToMove", "com/intellij/refactoring/util/RefactoringHierarchyUtil", "willBeInTargetClass"));
        }
        for (PsiElement parent = place; parent != null; parent = parent.getParent()) {
            if (membersToMove.contains(parent)) {
                return true;
            }
            if (parent instanceof PsiModifierList) {
                return false;
            }
            if (!(parent instanceof PsiClass) || targetClass == null) continue;
            if (targetClass.equals(parent)) {
                return true;
            }
            if (!includeSubclasses || !((PsiClass)parent).isInheritor(targetClass, true)) continue;
            return true;
        }
        return false;
    }

    public static PsiClass getDeepestNonObjectBase(PsiClass aClass) {
        PsiClass current = aClass;
        while (current != null) {
            PsiClassType[] supers = current.getExtendsListTypes();
            if (supers.length == 0) {
                return current;
            }
            PsiClass base = supers[0].resolve();
            if (base != null) {
                current = base;
                continue;
            }
            return current;
        }
        return null;
    }

    @Nullable
    public static PsiClass getNearestBaseClass(PsiClass subClass, boolean includeNonProject) {
        PsiClassType[] superTypes = subClass.getSuperTypes();
        if (superTypes.length > 0) {
            PsiClass resolved = superTypes[0].resolve();
            if (resolved != null && "java.lang.Object".equals(resolved.getQualifiedName()) && superTypes.length > 1) {
                resolved = superTypes[1].resolve();
            }
            if (resolved != null) {
                if (!includeNonProject) {
                    if (resolved.getManager().isInProject((PsiElement)resolved)) {
                        return resolved;
                    }
                } else {
                    return resolved;
                }
            }
        }
        return null;
    }

    public static ArrayList<PsiClass> createBasesList(PsiClass subClass, boolean includeNonProject, boolean sortAlphabetically) {
        LinkedHashSet<PsiClass> bases = new LinkedHashSet<PsiClass>();
        InheritanceUtil.getSuperClasses((PsiClass)subClass, bases, (boolean)includeNonProject);
        if (!subClass.isInterface()) {
            PsiManager manager = subClass.getManager();
            PsiClass javaLangObject = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Object", subClass.getResolveScope());
            if (includeNonProject && javaLangObject != null && !manager.areElementsEquivalent((PsiElement)javaLangObject, (PsiElement)subClass)) {
                bases.add(javaLangObject);
            }
        }
        ArrayList<PsiClass> basesList = new ArrayList<PsiClass>(bases);
        if (sortAlphabetically) {
            Collections.sort(basesList, (c1, c2) -> {
                String fqn1 = c1.getQualifiedName();
                String fqn2 = c2.getQualifiedName();
                if (fqn1 != null && fqn2 != null) {
                    return fqn1.compareTo(fqn2);
                }
                if (fqn1 == null && fqn2 == null) {
                    return Comparing.compare((Comparable)((Object)c1.getName()), (Comparable)((Object)c2.getName()));
                }
                return fqn1 == null ? 1 : -1;
            });
        }
        return basesList;
    }

    public static boolean isMemberBetween(PsiClass superClass, PsiClass subClass, PsiMember member) {
        PsiClass elementClass = null;
        if (member instanceof PsiField || member instanceof PsiMethod) {
            elementClass = member.getContainingClass();
        }
        if (elementClass == null) {
            return false;
        }
        if (superClass != null) {
            if (elementClass.isInheritor(superClass, true)) {
                return !superClass.getManager().areElementsEquivalent((PsiElement)superClass, (PsiElement)elementClass);
            }
            return PsiTreeUtil.isAncestor((PsiElement)elementClass, (PsiElement)subClass, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)elementClass, (PsiElement)superClass, (boolean)false);
        }
        return subClass.getManager().areElementsEquivalent((PsiElement)subClass, (PsiElement)elementClass);
    }

    public static void processSuperTypes(PsiType type, SuperTypeVisitor visitor) {
        RefactoringHierarchyUtil.processSuperTypes(type, visitor, (Set<PsiType>)new HashSet());
    }

    private static void processSuperTypes(PsiType type, SuperTypeVisitor visitor, Set<PsiType> visited) {
        block4: {
            PsiType[] superTypes;
            block3: {
                if (visited.contains(type)) {
                    return;
                }
                visited.add(type);
                if (!(type instanceof PsiPrimitiveType)) break block3;
                int index = PRIMITIVE_TYPES.indexOf(type);
                if (index < 0) break block4;
                for (int i = index + 1; i < PRIMITIVE_TYPES.size(); ++i) {
                    visitor.visitType(PRIMITIVE_TYPES.get(i));
                }
                break block4;
            }
            for (PsiType superType : superTypes = type.getSuperTypes()) {
                visitor.visitType(superType);
                RefactoringHierarchyUtil.processSuperTypes(superType, visitor, visited);
            }
        }
    }

    public static PsiClass[] findImplementingClasses(PsiClass anInterface) {
        HashSet result2 = new HashSet();
        RefactoringHierarchyUtil._findImplementingClasses(anInterface, (Set<PsiClass>)new HashSet(), (Collection<PsiClass>)result2);
        boolean classesRemoved = true;
        block0: while (classesRemoved) {
            classesRemoved = false;
            Iterator iterator = result2.iterator();
            while (iterator.hasNext()) {
                PsiClass psiClass = (PsiClass)iterator.next();
                for (PsiClass aClass : result2) {
                    if (!psiClass.isInheritor(aClass, true)) continue;
                    iterator.remove();
                    classesRemoved = true;
                    continue block0;
                }
            }
        }
        return result2.toArray(new PsiClass[result2.size()]);
    }

    private static void _findImplementingClasses(PsiClass anInterface, final Set<PsiClass> visited, final Collection<PsiClass> result2) {
        LOG.assertTrue(anInterface.isInterface());
        visited.add(anInterface);
        ClassInheritorsSearch.search((PsiClass)anInterface, (boolean)false).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

            public boolean execute(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/refactoring/util/RefactoringHierarchyUtil$1", "execute"));
                }
                if (!aClass.isInterface()) {
                    result2.add(aClass);
                } else if (!visited.contains(aClass)) {
                    RefactoringHierarchyUtil._findImplementingClasses(aClass, visited, result2);
                }
                return true;
            }
        }));
    }

    public static interface SuperTypeVisitor {
        public void visitType(PsiType var1);

        public void visitClass(PsiClass var1);
    }
}

