/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.PlatformTestUtil;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TempDirectory
extends TemporaryFolder {
    private String myName = null;
    private File myRoot = null;

    public Statement apply(Statement base, Description description) {
        this.myName = PlatformTestUtil.lowercaseFirstLetter(FileUtil.sanitizeFileName((String)description.getMethodName(), (boolean)false), true);
        return super.apply(base, description);
    }

    protected void before() throws IOException {
        if (this.myName == null) {
            throw new IllegalStateException("apply() was not called");
        }
        File dir = File.createTempFile("unitTest_" + this.myName + "_", "");
        Assert.assertTrue((String)("Cannot delete: " + dir.getPath()), (dir.delete() || !dir.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Cannot create: " + dir.getPath()), (dir.mkdir() || dir.isDirectory() ? 1 : 0) != 0);
        this.myRoot = dir.getCanonicalFile();
    }

    protected void after() {
        if (this.myRoot == null) {
            throw new IllegalStateException("before() was not called");
        }
        FileUtil.delete((File)this.myRoot);
        this.myRoot = null;
        this.myName = null;
    }

    public File getRoot() {
        if (this.myRoot == null) {
            throw new IllegalStateException("before() was not called");
        }
        return this.myRoot;
    }

    public File newFolder(String directoryName) throws IOException {
        File dir = new File(this.getRoot(), directoryName);
        if (dir.exists()) {
            throw new IOException("Already exists: " + dir);
        }
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create: " + dir);
        }
        return dir;
    }

    public File newFile(String fileName) throws IOException {
        File file2 = new File(this.getRoot(), fileName);
        File parent = file2.getParentFile();
        if (file2.exists()) {
            throw new IOException("Already exists: " + file2);
        }
        if (!parent.isDirectory() && !parent.mkdirs() || !file2.createNewFile()) {
            throw new IOException("Cannot create: " + file2);
        }
        return file2;
    }
}

