/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.testIntegration.ConfigurationByRecordProvider;
import com.intellij.testIntegration.RecentTestsData;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.TestLocator;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;

public class RecentTestsListProvider {
    private final Map<String, TestStateStorage.Record> myRecords;
    private final ConfigurationByRecordProvider myConfigurationProvider;

    public RecentTestsListProvider(ConfigurationByRecordProvider configurationProvider, Map<String, TestStateStorage.Record> records) {
        this.myRecords = records;
        this.myConfigurationProvider = configurationProvider;
    }

    public List<RecentTestsPopupEntry> getTestsToShow() {
        if (this.myRecords == null) {
            return ContainerUtil.emptyList();
        }
        RecentTestsData data = new RecentTestsData();
        for (Map.Entry<String, TestStateStorage.Record> entry : this.myRecords.entrySet()) {
            String url = entry.getKey();
            TestStateStorage.Record record = entry.getValue();
            if (!TestLocator.canLocate(url)) continue;
            this.handleUrl(data, url, record);
        }
        return data.getTestsToShow();
    }

    private void handleUrl(RecentTestsData data, String url, TestStateStorage.Record record) {
        TestStateInfo.Magnitude magnitude2 = RecentTestsListProvider.getMagnitude(record.magnitude);
        if (magnitude2 == null) {
            return;
        }
        RunnerAndConfigurationSettings runConfiguration = this.myConfigurationProvider.getConfiguration(record);
        if (TestLocator.isSuite(url)) {
            data.addSuite(url, magnitude2, record.date, runConfiguration);
        } else {
            data.addTest(url, magnitude2, record.date, runConfiguration);
        }
    }

    private static TestStateInfo.Magnitude getMagnitude(int magnitude2) {
        for (TestStateInfo.Magnitude m : TestStateInfo.Magnitude.values()) {
            if (m.getValue() != magnitude2) continue;
            return m;
        }
        return null;
    }
}

