/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestIntegrationUtils {
    private static final Logger LOG = Logger.getInstance((String)("#" + TestIntegrationUtils.class.getName()));

    public static boolean isTest(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testIntegration/TestIntegrationUtils", "isTest"));
        }
        PsiClass klass = TestIntegrationUtils.findOuterClass(element);
        return klass != null && TestFrameworks.getInstance().isTestClass(klass);
    }

    @Nullable
    public static PsiClass findOuterClass(@NotNull PsiElement element) {
        PsiClass[] classes;
        PsiFile containingFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testIntegration/TestIntegrationUtils", "findOuterClass"));
        }
        PsiClass result2 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (result2 == null && (containingFile = element.getContainingFile()) instanceof PsiClassOwner && (classes = ((PsiClassOwner)containingFile).getClasses()).length == 1) {
            result2 = classes[0];
        }
        if (result2 == null) {
            return null;
        }
        PsiClass nextParent;
        while ((nextParent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)result2, PsiClass.class, (boolean)true)) != null) {
            result2 = nextParent;
        }
        return result2;
    }

    public static List<MemberInfo> extractClassMethods(PsiClass clazz, boolean includeInherited) {
        ArrayList<MemberInfo> result2 = new ArrayList<MemberInfo>();
        do {
            MemberInfo.extractClassMembers(clazz, result2, new MemberInfoBase.Filter<PsiMember>(){

                public boolean includeMember(PsiMember member) {
                    if (!(member instanceof PsiMethod)) {
                        return false;
                    }
                    PsiModifierList list = member.getModifierList();
                    return !list.hasModifierProperty("private");
                }
            }, false);
        } while ((clazz = clazz.getSuperClass()) != null && clazz.getSuperClass() != null && includeInherited);
        return result2;
    }

    public static void runTestMethodTemplate(@NotNull MethodKind methodKind, TestFramework framework, Editor editor, PsiClass targetClass, PsiMethod method, @Nullable String name, boolean automatic, Set<String> existingNames) {
        if (methodKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodKind", "com/intellij/testIntegration/TestIntegrationUtils", "runTestMethodTemplate"));
        }
        TestIntegrationUtils.runTestMethodTemplate(methodKind, framework, editor, targetClass, null, method, name, automatic, existingNames);
    }

    public static void runTestMethodTemplate(@NotNull MethodKind methodKind, TestFramework framework, Editor editor, PsiClass targetClass, @Nullable PsiClass sourceClass, PsiMethod method, @Nullable String name, boolean automatic, Set<String> existingNames) {
        if (methodKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodKind", "com/intellij/testIntegration/TestIntegrationUtils", "runTestMethodTemplate"));
        }
        TestIntegrationUtils.runTestMethodTemplate(editor, targetClass, method, automatic, TestIntegrationUtils.createTestMethodTemplate(methodKind, framework, targetClass, sourceClass, name, automatic, existingNames));
    }

    public static void runTestMethodTemplate(final Editor editor, PsiClass targetClass, PsiMethod method, boolean automatic, Template template) {
        int startOffset = method.getModifierList().getTextRange().getStartOffset();
        TextRange range = new TextRange(startOffset, method.getTextRange().getEndOffset());
        editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"");
        editor.getCaretModel().moveToOffset(range.getStartOffset());
        final Project project2 = targetClass.getProject();
        TemplateEditingAdapter adapter = null;
        if (!automatic) {
            adapter = new TemplateEditingAdapter(){

                @Override
                public void templateFinished(Template template, boolean brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        PsiMethod method1;
                        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                        PsiFile psi = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
                        PsiElement el = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psi, (int)(editor.getCaretModel().getOffset() - 1), PsiMethod.class, (boolean)false);
                        if (el != null && (method1 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)el, PsiMethod.class, (boolean)false)) != null) {
                            if (method1.findDeepestSuperMethods().length > 0) {
                                GenerateMembersUtil.setupGeneratedMethod(method1);
                            }
                            CreateFromUsageUtils.setupEditor(method1, editor);
                        }
                    });
                }
            };
        }
        TemplateManager.getInstance(project2).startTemplate(editor, template, adapter);
    }

    public static Template createTestMethodTemplate(@NotNull MethodKind methodKind, TestFramework descriptor, @NotNull PsiClass targetClass, @Nullable String name, boolean automatic, Set<String> existingNames) {
        if (methodKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodKind", "com/intellij/testIntegration/TestIntegrationUtils", "createTestMethodTemplate"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/testIntegration/TestIntegrationUtils", "createTestMethodTemplate"));
        }
        return TestIntegrationUtils.createTestMethodTemplate(methodKind, descriptor, targetClass, null, name, automatic, existingNames);
    }

    public static Template createTestMethodTemplate(@NotNull MethodKind methodKind, TestFramework descriptor, @NotNull PsiClass targetClass, @Nullable PsiClass sourceClass, @Nullable String name, boolean automatic, Set<String> existingNames) {
        int index;
        String templateText;
        if (methodKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodKind", "com/intellij/testIntegration/TestIntegrationUtils", "createTestMethodTemplate"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/testIntegration/TestIntegrationUtils", "createTestMethodTemplate"));
        }
        FileTemplateDescriptor templateDesc = methodKind.getFileTemplateDescriptor(descriptor);
        String templateName = templateDesc.getFileName();
        FileTemplate fileTemplate = FileTemplateManager.getInstance(targetClass.getProject()).getCodeTemplate(templateName);
        Template template = TemplateManager.getInstance(targetClass.getProject()).createTemplate("", "");
        try {
            Properties properties = new Properties();
            if (sourceClass != null && sourceClass.isValid()) {
                properties.setProperty("CLASS_NAME", sourceClass.getQualifiedName());
            }
            templateText = fileTemplate.getText(properties);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            templateText = fileTemplate.getText();
        }
        if (name == null) {
            name = methodKind.getDefaultName();
        }
        if (existingNames != null && !existingNames.add(name)) {
            int idx = 1;
            while (existingNames.contains(name)) {
                String newName = name + idx++;
                if (!existingNames.add(newName)) continue;
                name = newName;
                break;
            }
        }
        templateText = StringUtil.replace((String)templateText, (String)"${BODY}", (String)"");
        int from = 0;
        while ((index = templateText.indexOf("${NAME}", from)) != -1) {
            template.addTextSegment(templateText.substring(from, index));
            name = index > 0 && !Character.isWhitespace(templateText.charAt(index - 1)) ? StringUtil.capitalize((String)name) : StringUtil.decapitalize((String)name);
            if (from == 0) {
                ConstantNode nameExpr = new ConstantNode(name);
                template.addVariable("name", nameExpr, nameExpr, !automatic);
            } else {
                template.addVariableSegment("name");
            }
            from = index + "${NAME}".length();
        }
        template.addTextSegment(templateText.substring(from, templateText.length()));
        template.setToIndent(true);
        template.setToReformat(true);
        template.setToShortenLongNames(true);
        return template;
    }

    public static PsiMethod createDummyMethod(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/testIntegration/TestIntegrationUtils", "createDummyMethod"));
        }
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)context.getLanguage(), (Project)context.getProject());
        if (factory == null) {
            factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        }
        return factory.createMethod("dummy", (PsiType)PsiType.VOID);
    }

    public static List<TestFramework> findSuitableFrameworks(PsiClass targetClass) {
        TestFramework[] frameworks;
        for (TestFramework each : frameworks = (TestFramework[])Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME)) {
            if (!each.isTestClass((PsiElement)targetClass)) continue;
            return Collections.singletonList(each);
        }
        SmartList result2 = new SmartList();
        for (TestFramework each : frameworks) {
            if (!each.isPotentialTestClass((PsiElement)targetClass)) continue;
            result2.add(each);
        }
        return result2;
    }

    private TestIntegrationUtils() {
    }

    public static enum MethodKind {
        SET_UP("setUp"){

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework framework) {
                if (framework == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/testIntegration/TestIntegrationUtils$MethodKind$1", "getFileTemplateDescriptor"));
                }
                return framework.getSetUpMethodFileTemplateDescriptor();
            }
        }
        ,
        TEAR_DOWN("tearDown"){

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework framework) {
                if (framework == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/testIntegration/TestIntegrationUtils$MethodKind$2", "getFileTemplateDescriptor"));
                }
                return framework.getTearDownMethodFileTemplateDescriptor();
            }
        }
        ,
        TEST("test"){

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework framework) {
                if (framework == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/testIntegration/TestIntegrationUtils$MethodKind$3", "getFileTemplateDescriptor"));
                }
                return framework.getTestMethodFileTemplateDescriptor();
            }
        }
        ,
        DATA("data"){

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework framework) {
                if (framework == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/testIntegration/TestIntegrationUtils$MethodKind$4", "getFileTemplateDescriptor"));
                }
                if (framework instanceof JavaTestFramework) {
                    return ((JavaTestFramework)framework).getParametersMethodFileTemplateDescriptor();
                }
                return null;
            }
        }
        ,
        TEST_CLASS("testClass"){

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework framework) {
                if (framework == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/testIntegration/TestIntegrationUtils$MethodKind$5", "getFileTemplateDescriptor"));
                }
                if (framework instanceof JavaTestFramework) {
                    return ((JavaTestFramework)framework).getTestClassFileTemplateDescriptor();
                }
                return null;
            }
        };

        private final String myDefaultName;

        private MethodKind(String defaultName) {
            this.myDefaultName = defaultName;
        }

        public String getDefaultName() {
            return this.myDefaultName;
        }

        public abstract FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework var1);
    }
}

