/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldWithAutoCompletionListProvider<T>
extends DefaultTextCompletionValueDescriptor<T>
implements TextCompletionProvider {
    private static final Logger LOG = Logger.getInstance(TextFieldWithAutoCompletionListProvider.class);
    @NotNull
    protected Collection<T> myVariants;
    @Nullable
    private String myCompletionAdvertisement;

    protected TextFieldWithAutoCompletionListProvider(@Nullable Collection<T> variants) {
        this.setItems(variants);
        this.myCompletionAdvertisement = null;
    }

    @Override
    @Nullable
    public String getPrefix(@NotNull String text, int offset) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "getPrefix"));
        }
        return TextFieldWithAutoCompletionListProvider.getCompletionPrefix(text, offset);
    }

    @Override
    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "applyPrefixMatcher"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "applyPrefixMatcher"));
        }
        PrefixMatcher prefixMatcher = this.createPrefixMatcher(prefix);
        if (prefixMatcher != null) {
            CompletionResultSet completionResultSet = result2.withPrefixMatcher(prefixMatcher);
            if (completionResultSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "applyPrefixMatcher"));
            }
            return completionResultSet;
        }
        CompletionResultSet completionResultSet = result2;
        if (completionResultSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "applyPrefixMatcher"));
        }
        return completionResultSet;
    }

    @Override
    @Nullable
    public CharFilter.Result acceptChar(char c) {
        return null;
    }

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "fillCompletionVariants"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "fillCompletionVariants"));
        }
        Collection<T> items = this.getItems(prefix, true, parameters);
        TextFieldWithAutoCompletionListProvider.addCompletionElements(result2, this, items, -10000);
        ProgressManager progressManager = ProgressManager.getInstance();
        ProgressIndicator mainIndicator = progressManager.getProgressIndicator();
        SensitiveProgressWrapper indicator = mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new EmptyProgressIndicator();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "lambda$fillCompletionVariants$1"));
            }
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "lambda$fillCompletionVariants$1"));
            }
            return (Collection)progressManager.runProcess(() -> {
                if (prefix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "lambda$null$0"));
                }
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "lambda$null$0"));
                }
                return this.getItems(prefix, false, parameters);
            }, indicator);
        });
        while (true) {
            try {
                Collection tasks = (Collection)future2.get(100L, TimeUnit.MILLISECONDS);
                if (tasks != null) {
                    TextFieldWithAutoCompletionListProvider.addCompletionElements(result2, this, tasks, 0);
                    return;
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProgressManager.checkCanceled();
        }
    }

    private static <T> void addCompletionElements(CompletionResultSet result2, TextCompletionValueDescriptor<T> descriptor, Collection<T> items, int index) {
        AutoCompletionPolicy completionPolicy = ApplicationManager.getApplication().isUnitTestMode() ? AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE : AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
        int grouping = index;
        for (T item : items) {
            if (item == null) {
                LOG.error("Null item from " + descriptor);
                continue;
            }
            LookupElementBuilder builder = descriptor.createLookupBuilder(item);
            result2.addElement(PrioritizedLookupElement.withGrouping((LookupElement)builder.withAutoCompletionPolicy(completionPolicy), (int)grouping--));
        }
    }

    public void setItems(@Nullable Collection<T> variants) {
        this.myVariants = variants != null ? variants : Collections.emptyList();
    }

    @NotNull
    public Collection<T> getItems(String prefix, boolean cached, CompletionParameters parameters) {
        if (prefix == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "getItems"));
            }
            return list;
        }
        ArrayList<T> items = new ArrayList<T>(this.myVariants);
        Collections.sort(items, this);
        ArrayList<T> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "getItems"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getAdvertisement() {
        if (this.myCompletionAdvertisement != null) {
            return this.myCompletionAdvertisement;
        }
        String shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"QuickJavaDoc");
        String advertisementTail = this.getQuickDocHotKeyAdvertisementTail(shortcut);
        if (advertisementTail == null) {
            return null;
        }
        return "Pressing " + shortcut + " would show " + advertisementTail;
    }

    @Nullable
    protected String getQuickDocHotKeyAdvertisementTail(@NotNull String shortcut) {
        if (shortcut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcut", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "getQuickDocHotKeyAdvertisementTail"));
        }
        return null;
    }

    public void setAdvertisement(@Nullable String completionAdvertisement) {
        this.myCompletionAdvertisement = completionAdvertisement;
    }

    @Nullable
    public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "createPrefixMatcher"));
        }
        return new PlainPrefixMatcher(prefix);
    }

    @NotNull
    public static String getCompletionPrefix(CompletionParameters parameters) {
        String text = parameters.getOriginalFile().getText();
        int offset = parameters.getOffset();
        String string = TextFieldWithAutoCompletionListProvider.getCompletionPrefix(text, offset);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "getCompletionPrefix"));
        }
        return string;
    }

    @NotNull
    private static String getCompletionPrefix(String text, int offset) {
        int i = text.lastIndexOf(32, offset - 1) + 1;
        int j = text.lastIndexOf(10, offset - 1) + 1;
        String string = text.substring(Math.max(i, j), offset);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TextFieldWithAutoCompletionListProvider", "getCompletionPrefix"));
        }
        return string;
    }
}

