/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UsageViewUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usageView.UsageViewUtil");

    private UsageViewUtil() {
    }

    public static String createNodeText(PsiElement element) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewNodeTextLocation.INSTANCE);
    }

    public static String getShortName(PsiElement psiElement) {
        LOG.assertTrue(psiElement.isValid(), (Object)psiElement);
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
    }

    public static String getLongName(PsiElement psiElement) {
        LOG.assertTrue(psiElement.isValid(), (Object)psiElement);
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE);
    }

    public static String getType(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/usageView/UsageViewUtil", "getType"));
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
    }

    public static boolean hasNonCodeUsages(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (!usage.isNonCodeUsage) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUsagesInGeneratedCode(UsageInfo[] usages, Project project2) {
        for (UsageInfo usage : usages) {
            VirtualFile file2 = usage.getVirtualFile();
            if (file2 == null || !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)project2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadOnlyUsages(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (usage.isWritable()) continue;
            return true;
        }
        return false;
    }

    public static UsageInfo[] removeDuplicatedUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/usageView/UsageViewUtil", "removeDuplicatedUsages"));
        }
        LinkedHashSet<UsageInfo> set = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
        String newTextInNonCodeUsage = null;
        for (UsageInfo usage : usages) {
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            newTextInNonCodeUsage = ((NonCodeUsageInfo)usage).newText;
            break;
        }
        if (newTextInNonCodeUsage != null) {
            for (UsageInfo usage : usages) {
                PsiReference psiReference;
                PsiElement usageElement;
                PsiLanguageInjectionHost context;
                PsiFile file2;
                if (!(usage instanceof MoveRenameUsageInfo) || (file2 = usage.getFile()) == null || (context = InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)file2)) == null || (usageElement = usage.getElement()) == null || (psiReference = usage.getReference()) == null) continue;
                int injectionOffsetInMasterFile = InjectedLanguageManager.getInstance((Project)usageElement.getProject()).injectedToHost(usageElement, usageElement.getTextOffset());
                ProperTextRange rangeInElement = usage.getRangeInElement();
                assert (rangeInElement != null) : usage;
                TextRange range = rangeInElement.shiftRight(injectionOffsetInMasterFile);
                PsiFile containingFile = context.getContainingFile();
                if (containingFile == null) continue;
                set.remove(NonCodeUsageInfo.create((PsiFile)containingFile, (int)range.getStartOffset(), (int)range.getEndOffset(), (PsiElement)((MoveRenameUsageInfo)usage).getReferencedElement(), (String)newTextInNonCodeUsage));
            }
        }
        return set.toArray(new UsageInfo[set.size()]);
    }

    @NotNull
    public static UsageInfo[] toUsageInfoArray(@NotNull Collection<? extends UsageInfo> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/usageView/UsageViewUtil", "toUsageInfoArray"));
        }
        int size = collection.size();
        UsageInfo[] usageInfoArray = size == 0 ? UsageInfo.EMPTY_ARRAY : collection.toArray(new UsageInfo[size]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usageView/UsageViewUtil", "toUsageInfoArray"));
        }
        return usageInfoArray;
    }

    @NotNull
    public static PsiElement[] toElements(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/usageView/UsageViewUtil", "toElements"));
        }
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Object[])usageInfos, PsiElement.class, info -> info.getElement());
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usageView/UsageViewUtil", "toElements"));
        }
        return psiElementArray;
    }

    public static void navigateTo(@NotNull UsageInfo info, boolean requestFocus) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/usageView/UsageViewUtil", "navigateTo"));
        }
        int offset = info.getNavigationOffset();
        VirtualFile file2 = info.getVirtualFile();
        Project project2 = info.getProject();
        if (file2 != null) {
            FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, file2, offset), requestFocus);
        }
    }

    public static Set<UsageInfo> getNotExcludedUsageInfos(UsageView usageView) {
        Set excludedUsages = usageView.getExcludedUsages();
        LinkedHashSet<UsageInfo> usageInfos = new LinkedHashSet<UsageInfo>();
        for (Usage usage : usageView.getUsages()) {
            if (!(usage instanceof UsageInfo2UsageAdapter) || excludedUsages.contains(usage)) continue;
            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
            usageInfos.add(usageInfo);
        }
        return usageInfos;
    }

    public static boolean reportNonRegularUsages(UsageInfo[] usages, Project project2) {
        boolean inGeneratedCode = UsageViewUtil.hasUsagesInGeneratedCode(usages, project2);
        if (UsageViewUtil.hasNonCodeUsages(usages) || inGeneratedCode) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
            if (statusBar != null) {
                statusBar.setInfo(RefactoringBundle.message((String)(inGeneratedCode ? "occurrences.found.in.comments.strings.non.java.files.and.generated.code" : "occurrences.found.in.comments.strings.and.non.java.files")));
            }
            return true;
        }
        return false;
    }
}

