/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.JdomKt;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.Reference;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.ConstantsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.EntityResolver;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\u001a\b\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\n\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"cachedSaxBuilder", "Ljava/lang/ThreadLocal;", "Lcom/intellij/reference/SoftReference;", "Lorg/jdom/input/SAXBuilder;", "getSaxBuilder", "loadDocument", "Lorg/jdom/Document;", "reader", "Ljava/io/Reader;", "loadElement", "Lorg/jdom/Element;", "kotlin.jvm.PlatformType", "stream", "Ljava/io/InputStream;", "path", "Ljava/nio/file/Path;", "chars", "", "getTreeHash", "", "platform-impl"})
public final class JdomKt {
    private static final ThreadLocal<SoftReference<SAXBuilder>> cachedSaxBuilder = new ThreadLocal();

    private static final SAXBuilder getSaxBuilder() {
        SoftReference<SAXBuilder> reference = cachedSaxBuilder.get();
        SAXBuilder saxBuilder = (SAXBuilder)SoftReference.dereference((Reference)((Reference)reference));
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
            saxBuilder.setIgnoringBoundaryWhitespace(true);
            saxBuilder.setIgnoringElementContentWhitespace(true);
            saxBuilder.setEntityResolver((EntityResolver)getSaxBuilder.1.INSTANCE);
            cachedSaxBuilder.set((SoftReference<SAXBuilder>)new SoftReference((Object)saxBuilder));
        }
        return saxBuilder;
    }

    public static final Element loadElement(@NotNull CharSequence chars) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        return JdomKt.loadElement((Reader)new CharSequenceReader(chars));
    }

    public static final Element loadElement(@NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        return JdomKt.loadDocument(reader).detachRootElement();
    }

    public static final Element loadElement(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        InputStream inputStream = stream;
        Charset charset = null;
        boolean bl = true;
        Object var4_4 = null;
        if (var4_4 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        return JdomKt.loadDocument(new InputStreamReader(inputStream, charset)).detachRootElement();
    }

    public static final Element loadElement(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        Charset charset = null;
        boolean bl = true;
        Closeable closeable = null;
        if (closeable != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bufferedReader");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        closeable = inputStream;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        int n = 0;
        boolean bl2 = true;
        Object var7_7 = null;
        if (var7_7 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl2 & true) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        return JdomKt.loadDocument(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)).detachRootElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Document loadDocument(Reader reader) {
        try {
            Document document2 = JdomKt.getSaxBuilder().build(reader);
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"getSaxBuilder().build(reader)");
            Document document3 = document2;
            return document3;
        }
        finally {
            reader.close();
        }
    }

    public static final int getTreeHash(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return JDOMUtil.getTreeHash((Element)$receiver);
    }
}

