/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.UtilKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0012\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00020\u0002*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a\u0012\u0010\u000b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u001a\n\u0010\r\u001a\u00020\n*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0002*\u00020\u0002\u001a4\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u0010*\u00020\u00022\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0013\u0012\u0004\u0012\u0002H\u00100\u0012H\u0086\b\u00a2\u0006\u0002\u0010\u0014\u001aJ\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u0010*\u00020\u00022\u0014\b\b\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00160\u00122\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0013\u0012\u0004\u0012\u0002H\u00100\u0012H\u0086\b\u00a2\u0006\u0002\u0010\u0017\u001a\n\u0010\u0018\u001a\u00020\u0016*\u00020\u0002\u001a\u0012\u0010\u0019\u001a\n \b*\u0004\u0018\u00010\u001a0\u001a*\u00020\u0002\u001a\n\u0010\u001b\u001a\u00020\u0016*\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\u0016*\u00020\u0002\u001a\n\u0010\u001d\u001a\u00020\u0016*\u00020\u0002\u001a\u0012\u0010\u001e\u001a\n \b*\u0004\u0018\u00010\u001f0\u001f*\u00020\u0002\u001a\u001a\u0010 \u001a\n \b*\u0004\u0018\u00010\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u001a\n\u0010!\u001a\u00020\"*\u00020\u0002\u001a\u0012\u0010#\u001a\n \b*\u0004\u0018\u00010$0$*\u00020\u0002\u001a\n\u0010%\u001a\u00020&*\u00020\u0002\u001a\n\u0010'\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010(\u001a\u00020\n*\u00020\u0002\u001a\n\u0010)\u001a\u00020**\u00020\u0002\u001a\n\u0010+\u001a\u00020**\u00020\u0002\u001a&\u0010,\u001a\u00020\u0002*\u00020\u00022\u0006\u0010-\u001a\u00020$2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020/\u001a\u0012\u0010,\u001a\u00020\u0002*\u00020\u00022\u0006\u0010-\u001a\u00020\u0001\u001a\u001a\u00101\u001a\u00020\u0002*\u00020\u00022\u0006\u00102\u001a\u00020\u00012\u0006\u0010-\u001a\u00020$\u001a\u001a\u00101\u001a\u00020\u0002*\u00020\u00022\u0006\u00102\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u00063"}, d2={"parentSystemIndependentPath", "", "Ljava/nio/file/Path;", "getParentSystemIndependentPath", "(Ljava/nio/file/Path;)Ljava/lang/String;", "systemIndependentPath", "getSystemIndependentPath", "createDirectories", "kotlin.jvm.PlatformType", "createFile", "", "createSymbolicLink", "target", "delete", "deleteRecursively", "directoryStreamIfExists", "R", "task", "Lkotlin/Function1;", "Ljava/nio/file/DirectoryStream;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "filter", "", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "exists", "inputStream", "Ljava/io/InputStream;", "isDirectory", "isFile", "isHidden", "lastModified", "Ljava/nio/file/attribute/FileTime;", "move", "outputStream", "Ljava/io/OutputStream;", "readBytes", "", "readChars", "", "readText", "refreshVfs", "size", "", "sizeOrNull", "write", "data", "offset", "", "length", "writeChild", "relativePath", "platform-impl"})
public final class PathKt {
    public static final boolean exists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.exists($receiver, new LinkOption[0]);
    }

    public static final Path createDirectories(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.createDirectories($receiver, new FileAttribute[0]);
    }

    @NotNull
    public static final OutputStream outputStream(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path = $receiver.getParent();
        if (path != null) {
            PathKt.createDirectories(path);
        }
        OutputStream outputStream = Files.newOutputStream($receiver, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"Files.newOutputStream(this)");
        return outputStream;
    }

    public static final InputStream inputStream(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.newInputStream($receiver, new OpenOption[0]);
    }

    @NotNull
    public static final Path createSymbolicLink(@NotNull Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path path = $receiver.getParent();
        if (path != null) {
            PathKt.createDirectories(path);
        }
        Files.createSymbolicLink($receiver, target, new FileAttribute[0]);
        return $receiver;
    }

    public static final void delete(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            Files.delete($receiver);
        }
        catch (NoSuchFileException ignored) {
        }
        catch (Exception e) {
            FileUtil.delete((File)$receiver.toFile());
        }
    }

    @NotNull
    public static final Path deleteRecursively(@NotNull Path $receiver) {
        Path path;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (PathKt.exists($receiver)) {
            Path path2 = Files.walkFileTree($receiver, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @NotNull
                public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) {
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                    PathKt.delete(file2);
                    return FileVisitResult.CONTINUE;
                }

                @NotNull
                public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
                    Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                    PathKt.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            path = path2;
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Files.walkFileTree(this,\u2026sitResult.CONTINUE\n  }\n})");
        } else {
            path = $receiver;
        }
        return path;
    }

    public static final FileTime lastModified(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.getLastModifiedTime($receiver, new LinkOption[0]);
    }

    @NotNull
    public static final String getSystemIndependentPath(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.replace$default((String)((Object)$receiver).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getParentSystemIndependentPath(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path = $receiver.getParent();
        if (path == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.replace$default((String)((Object)path).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    public static final byte[] readBytes(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.readAllBytes($receiver);
    }

    @NotNull
    public static final String readText(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = PathKt.readBytes($receiver);
        Charset charset = Charsets.UTF_8;
        return new String(byArray, charset);
    }

    @NotNull
    public static final CharSequence readChars(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream inputStream = PathKt.inputStream($receiver);
        Charset charset = null;
        boolean bl = true;
        Object var4_4 = null;
        if (var4_4 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        return UtilKt.readCharSequence(new InputStreamReader(inputStream, charset), (int)PathKt.size($receiver));
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $receiver, @NotNull String relativePath, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return PathKt.write$default($receiver.resolve(relativePath), data, 0, 0, 6, null);
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $receiver, @NotNull String relativePath, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = data;
        Charset charset = null;
        boolean bl = true;
        Object var6_6 = null;
        String string2 = relativePath;
        Path path = $receiver;
        if (var6_6 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return PathKt.writeChild(path, string2, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path write(@NotNull Path $receiver, @NotNull byte[] data, int offset, int length) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Closeable closeable = PathKt.outputStream($receiver);
        boolean bl = false;
        try {
            OutputStream it = (OutputStream)closeable;
            it.write(data, offset, length);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            bl = true;
            try {
                closeable.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                closeable.close();
            }
        }
        return $receiver;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Path write$default(Path path, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return PathKt.write(path, byArray, n, n2);
    }

    @NotNull
    public static final Path write(@NotNull Path $receiver, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Path path = $receiver.getParent();
        if (path != null) {
            PathKt.createDirectories(path);
        }
        String string = data;
        Charset charset = null;
        boolean bl = true;
        Object var5_5 = null;
        Path path2 = $receiver;
        if (var5_5 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        Files.write(path2, byArray2, new OpenOption[0]);
        return $receiver;
    }

    public static final long size(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.size($receiver);
    }

    public static final long sizeOrNull(@NotNull Path $receiver) {
        BasicFileAttributes attributes;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes($receiver, BasicFileAttributes.class, new LinkOption[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)basicFileAttributes, (String)"Files.readAttributes(thi\u2026leAttributes::class.java)");
            attributes = basicFileAttributes;
        }
        catch (IOException ignored) {
            return -1L;
        }
        return attributes.size();
    }

    public static final boolean isHidden(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isHidden($receiver);
    }

    public static final boolean isDirectory(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isDirectory($receiver, new LinkOption[0]);
    }

    public static final boolean isFile(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isRegularFile($receiver, new LinkOption[0]);
    }

    public static final Path move(@NotNull Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return Files.move($receiver, target, new CopyOption[0]);
    }

    public static final void createFile(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path = $receiver.getParent();
        if (path != null) {
            PathKt.createDirectories(path);
        }
        Files.createFile($receiver, new FileAttribute[0]);
    }

    public static final void refreshVfs(@NotNull Path $receiver) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            if (localFileSystem == null) break block1;
            LocalFileSystem localFileSystem2 = localFileSystem;
            LocalFileSystem fs = localFileSystem2;
            VirtualFile virtualFile = fs.refreshAndFindFileByPath(PathKt.getSystemIndependentPath($receiver));
            if (virtualFile != null) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $receiver, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            Object object;
            Closeable closeable = Files.newDirectoryStream($receiver);
            boolean bl = false;
            try {
                object = task.invoke((Object)closeable);
            }
            catch (Exception exception) {
                bl = true;
                try {
                    closeable.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                if (!bl) {
                    closeable.close();
                }
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $receiver, @NotNull Function1<? super Path, Boolean> filter, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            Object object;
            Closeable closeable = Files.newDirectoryStream($receiver, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter){
                final /* synthetic */ Function1 $filter;

                public final boolean accept(Path it) {
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path);
                }
                {
                    this.$filter = function1;
                }
            });
            boolean bl = false;
            try {
                object = task.invoke((Object)closeable);
            }
            catch (Exception exception) {
                bl = true;
                try {
                    closeable.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                if (!bl) {
                    closeable.close();
                }
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException ignored) {
            return null;
        }
    }
}

