/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.util.graph.Graph;
import com.intellij.util.graph.impl.ShortestPathFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CycleFinder<Node> {
    private final Graph<Node> myGraph;

    public CycleFinder(Graph<Node> graph) {
        this.myGraph = graph;
    }

    @NotNull
    public Set<List<Node>> getNodeCycles(final Node node) {
        HashSet<List<Node>> result2 = new HashSet<List<Node>>();
        Graph graphWithoutNode = new Graph<Node>(){

            public Collection<Node> getNodes() {
                Collection nodes = CycleFinder.this.myGraph.getNodes();
                nodes.remove(node);
                return nodes;
            }

            public Iterator<Node> getIn(Node n) {
                HashSet nodes = new HashSet();
                Iterator in = CycleFinder.this.myGraph.getIn(n);
                while (in.hasNext()) {
                    nodes.add(in.next());
                }
                nodes.remove(node);
                return nodes.iterator();
            }

            public Iterator<Node> getOut(Node n) {
                HashSet nodes = new HashSet();
                Iterator out = CycleFinder.this.myGraph.getOut(n);
                while (out.hasNext()) {
                    nodes.add(out.next());
                }
                nodes.remove(node);
                return nodes.iterator();
            }
        };
        HashSet inNodes = new HashSet();
        Iterator in = this.myGraph.getIn(node);
        while (in.hasNext()) {
            inNodes.add(in.next());
        }
        HashSet outNodes = new HashSet();
        Iterator out = this.myGraph.getOut(node);
        while (out.hasNext()) {
            outNodes.add(out.next());
        }
        HashSet retainNodes = new HashSet(inNodes);
        retainNodes.retainAll(outNodes);
        for (Object node1 : retainNodes) {
            ArrayList<Object> oneNodeCycle = new ArrayList<Object>();
            oneNodeCycle.add(node1);
            oneNodeCycle.add(node);
            result2.add(oneNodeCycle);
        }
        inNodes.removeAll(retainNodes);
        outNodes.removeAll(retainNodes);
        ShortestPathFinder finder = new ShortestPathFinder(graphWithoutNode);
        for (Object fromNode : outNodes) {
            for (Object toNode : inNodes) {
                List shortestPath = finder.findPath(fromNode, toNode);
                if (shortestPath == null) continue;
                ArrayList<Node> path = new ArrayList<Node>();
                path.addAll(shortestPath);
                path.add(node);
                result2.add(path);
            }
        }
        HashSet<List<Node>> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/graph/impl/CycleFinder", "getNodeCycles"));
        }
        return hashSet;
    }
}

