/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.SmartList;
import com.intellij.util.indexing.DebugAssertions;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.ValueContainerImpl;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.List;

class FileId2ValueMapping<Value> {
    private TIntObjectHashMap<Value> id2ValueMap = new TIntObjectHashMap();
    private ValueContainerImpl<Value> valueContainer;
    private boolean myOnePerFileValidationEnabled = true;

    FileId2ValueMapping(ValueContainerImpl<Value> _valueContainer) {
        this.valueContainer = _valueContainer;
        TIntArrayList removedFileIdList = null;
        List removedValueList = null;
        ValueContainer.ValueIterator<Value> valueIterator = _valueContainer.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            ValueContainer.IntIterator intIterator = valueIterator.getInputIdsIterator();
            while (intIterator.hasNext()) {
                int id = intIterator.next();
                Object previousValue = this.id2ValueMap.put(id, value);
                if (previousValue == null) continue;
                if (removedFileIdList == null) {
                    removedFileIdList = new TIntArrayList();
                    removedValueList = new SmartList();
                }
                removedFileIdList.add(id);
                removedValueList.add(previousValue);
            }
        }
        if (removedFileIdList != null) {
            int size = removedFileIdList.size();
            for (int i = 0; i < size; ++i) {
                this.valueContainer.removeValue(removedFileIdList.get(i), removedValueList.get(i));
            }
        }
    }

    void associateFileIdToValue(int fileId, Value value) {
        Object previousValue = this.id2ValueMap.put(fileId, value);
        if (previousValue != null) {
            this.valueContainer.removeValue(fileId, previousValue);
        }
    }

    boolean removeFileId(int inputId) {
        Object mapped = this.id2ValueMap.remove(inputId);
        if (mapped != null) {
            this.valueContainer.removeValue(inputId, mapped);
        }
        if (DebugAssertions.EXTRA_SANITY_CHECKS && this.myOnePerFileValidationEnabled) {
            ValueContainer.ValueIterator<Value> valueIterator = this.valueContainer.getValueIterator();
            while (valueIterator.hasNext()) {
                valueIterator.next();
                DebugAssertions.assertTrue(!valueIterator.getValueAssociationPredicate().contains(inputId));
            }
        }
        return mapped != null;
    }

    public void disableOneValuePerFileValidation() {
        this.myOnePerFileValidationEnabled = false;
    }
}

