/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.CanonicalPsiTypeConverter;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanonicalPsiTypeConverterImpl
extends CanonicalPsiTypeConverter
implements CustomReferenceConverter<PsiType> {
    @NonNls
    static final String[] PRIMITIVES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
    @NonNls
    private static final String ARRAY_PREFIX = "[L";
    private static final JavaClassReferenceProvider CLASS_REFERENCE_PROVIDER = new JavaClassReferenceProvider();

    public PsiType fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        try {
            return JavaPsiFacade.getInstance((Project)context.getFile().getProject()).getElementFactory().createTypeFromText(s.replace('$', '.'), null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public String toString(PsiType t, ConvertContext context) {
        return t == null ? null : t.getCanonicalText();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiType> genericDomValue, PsiElement element, ConvertContext context) {
        String typeText = genericDomValue.getStringValue();
        if (typeText == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/CanonicalPsiTypeConverterImpl", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = this.getReferences((PsiType)genericDomValue.getValue(), typeText, 0, element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/CanonicalPsiTypeConverterImpl", "createReferences"));
        }
        return psiReferenceArray;
    }

    public PsiReference[] getReferences(@Nullable PsiType type, String typeText, int startOffsetInText, final @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/CanonicalPsiTypeConverterImpl", "getReferences"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        assert (manipulator != null);
        String trimmed = typeText.trim();
        int offset = manipulator.getRangeInElement(element).getStartOffset() + startOffsetInText + typeText.indexOf(trimmed);
        if (trimmed.startsWith(ARRAY_PREFIX)) {
            offset += ARRAY_PREFIX.length();
            trimmed = trimmed.endsWith(";") ? trimmed.substring(ARRAY_PREFIX.length(), trimmed.length() - 1) : trimmed.substring(ARRAY_PREFIX.length());
        }
        if (type != null) {
            type = type.getDeepComponentType();
        }
        final boolean isPrimitiveType = type instanceof PsiPrimitiveType;
        return new JavaClassReferenceSet(trimmed, element, offset, false, CLASS_REFERENCE_PROVIDER){

            @Override
            @NotNull
            protected JavaClassReference createReference(int refIndex, @NotNull String subRefText, @NotNull TextRange textRange, boolean staticImport) {
                if (subRefText == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subRefText", "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1", "createReference"));
                }
                if (textRange == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1", "createReference"));
                }
                JavaClassReference javaClassReference = new JavaClassReference(this, textRange, refIndex, subRefText, staticImport){

                    @Override
                    public boolean isSoft() {
                        return true;
                    }

                    @Override
                    @NotNull
                    public JavaResolveResult advancedResolve(boolean incompleteCode) {
                        if (isPrimitiveType) {
                            CandidateInfo candidateInfo = new CandidateInfo(element, PsiSubstitutor.EMPTY, false, false, element);
                            if (candidateInfo == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1$1", "advancedResolve"));
                            }
                            return candidateInfo;
                        }
                        JavaResolveResult javaResolveResult = super.advancedResolve(incompleteCode);
                        if (javaResolveResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1$1", "advancedResolve"));
                        }
                        return javaResolveResult;
                    }

                    @Override
                    public void processVariants(@NotNull PsiScopeProcessor processor2) {
                        if (processor2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1$1", "processVariants"));
                        }
                        if (processor2 instanceof JavaCompletionProcessor) {
                            ((JavaCompletionProcessor)processor2).setCompletionElements(this.getVariants());
                        } else {
                            super.processVariants(processor2);
                        }
                    }

                    @Override
                    @NotNull
                    public Object[] getVariants() {
                        Object[] variants = super.getVariants();
                        if (this.myIndex == 0) {
                            Object[] objectArray = ArrayUtil.mergeArrays((Object[])variants, (Object[])PRIMITIVES, (ArrayFactory)ArrayUtil.OBJECT_ARRAY_FACTORY);
                            if (objectArray == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1$1", "getVariants"));
                            }
                            return objectArray;
                        }
                        if (variants == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1$1", "getVariants"));
                        }
                        return variants;
                    }
                };
                if (javaClassReference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1", "createReference"));
                }
                return javaClassReference;
            }
        }.getAllReferences();
    }
}

