/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.impl.VirtualDomParentStrategy;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubParentStrategy
implements DomParentStrategy {
    private static final Logger LOG = Logger.getInstance(StubParentStrategy.class);
    protected final DomStub myStub;

    public StubParentStrategy(@NotNull DomStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/util/xml/stubs/StubParentStrategy", "<init>"));
        }
        this.myStub = stub;
    }

    public static StubParentStrategy createAttributeStrategy(@Nullable AttributeStub stub, @NotNull DomStub parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/stubs/StubParentStrategy", "createAttributeStrategy"));
        }
        if (stub == null) {
            return new Empty(parent);
        }
        return new StubParentStrategy(stub){

            @Override
            public XmlElement getXmlElement() {
                DomInvocationHandler parentHandler = this.getParentHandler();
                if (parentHandler == null) {
                    LOG.error("no parent handler for " + this);
                    return null;
                }
                XmlTag tag = parentHandler.getXmlTag();
                if (tag == null) {
                    LOG.error("can't find tag for " + (Object)((Object)parentHandler) + "\nparent stub: " + this.myStub.getParentStub() + "\nparent's children: " + ((DomStub)this.myStub.getParentStub()).getChildrenStubs());
                    return null;
                }
                return tag.getAttribute(this.myStub.getName());
            }
        };
    }

    @Override
    public DomInvocationHandler getParentHandler() {
        DomStub parentStub = (DomStub)this.myStub.getParentStub();
        return parentStub == null ? null : parentStub.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlElement getXmlElement() {
        XmlTag[] tags;
        DomStub parentStub = (DomStub)this.myStub.getParentStub();
        if (parentStub == null) {
            return null;
        }
        List<DomStub> children2 = parentStub.getChildrenStubs();
        if (children2.isEmpty()) {
            return null;
        }
        XmlTag parentTag = parentStub.getHandler().getXmlTag();
        if (parentTag == null) {
            return null;
        }
        try {
            XmlUtil.BUILDING_DOM_STUBS.set(true);
            tags = parentTag.getSubTags();
        }
        finally {
            XmlUtil.BUILDING_DOM_STUBS.set(false);
        }
        int i = 0;
        String nameToFind = this.myStub.getName();
        for (XmlTag xmlTag : tags) {
            if (!nameToFind.equals(xmlTag.getName()) || this.myStub.getIndex() != i++) continue;
            return xmlTag;
        }
        return null;
    }

    @Override
    @NotNull
    public DomParentStrategy refreshStrategy(DomInvocationHandler handler2) {
        StubParentStrategy stubParentStrategy = this;
        if (stubParentStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/StubParentStrategy", "refreshStrategy"));
        }
        return stubParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy setXmlElement(@NotNull XmlElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/stubs/StubParentStrategy", "setXmlElement"));
        }
        PhysicalDomParentStrategy physicalDomParentStrategy = new PhysicalDomParentStrategy(element, DomManagerImpl.getDomManager(element.getProject()));
        if (physicalDomParentStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/StubParentStrategy", "setXmlElement"));
        }
        return physicalDomParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy clearXmlElement() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        VirtualDomParentStrategy virtualDomParentStrategy = new VirtualDomParentStrategy(parent);
        if (virtualDomParentStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/StubParentStrategy", "clearXmlElement"));
        }
        return virtualDomParentStrategy;
    }

    @Override
    public String checkValidity() {
        return null;
    }

    @Override
    public XmlFile getContainingFile(DomInvocationHandler handler2) {
        return this.getParentHandler().getFile();
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StubParentStrategy)) {
            return PhysicalDomParentStrategy.strategyEquals(this, obj);
        }
        if (obj == this) {
            return true;
        }
        StubParentStrategy other = (StubParentStrategy)obj;
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        if (!other.myStub.equals((Object)this.myStub)) {
            return false;
        }
        return Comparing.equal((Object)this.getContainingFile(this.myStub.getHandler()), (Object)other.getContainingFile(other.myStub.getHandler()));
    }

    public static class Empty
    extends StubParentStrategy {
        private final DomStub myParent;

        public Empty(DomStub parent) {
            super(parent);
            this.myParent = parent;
        }

        @Override
        public DomInvocationHandler getParentHandler() {
            return this.myParent.getHandler();
        }

        @Override
        public XmlElement getXmlElement() {
            return null;
        }

        @Override
        public boolean isPhysical() {
            return false;
        }
    }
}

