/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.data.VcsLogData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopCommitsCache {
    @NotNull
    private final VcsLogHashMap myHashMap;
    @NotNull
    private final ConcurrentIntObjectMap<VcsCommitMetadata> myCache;
    @NotNull
    private List<VcsCommitMetadata> mySortedDetails;

    public TopCommitsCache(@NotNull VcsLogHashMap hashMap) {
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/TopCommitsCache", "<init>"));
        }
        this.myCache = ContainerUtil.createConcurrentIntObjectMap();
        this.mySortedDetails = ContainerUtil.newArrayList();
        this.myHashMap = hashMap;
    }

    private int getIndex(@NotNull VcsCommitMetadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/intellij/vcs/log/data/TopCommitsCache", "getIndex"));
        }
        return this.myHashMap.getCommitIndex((Hash)metadata.getId(), metadata.getRoot());
    }

    public void storeDetails(@NotNull List<? extends VcsCommitMetadata> sortedDetails) {
        if (sortedDetails == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedDetails", "com/intellij/vcs/log/data/TopCommitsCache", "storeDetails"));
        }
        List newDetails = ContainerUtil.filter(sortedDetails, metadata -> !this.myCache.containsValue(metadata));
        if (newDetails.isEmpty()) {
            return;
        }
        MergingIterator it = new MergingIterator(this.mySortedDetails, newDetails);
        ArrayList result2 = ContainerUtil.newArrayList();
        while (it.hasNext()) {
            VcsCommitMetadata detail = (VcsCommitMetadata)it.next();
            if (result2.size() < VcsLogData.RECENT_COMMITS_COUNT * 2) {
                result2.add(detail);
                this.myCache.put(this.getIndex(detail), (Object)detail);
                continue;
            }
            this.myCache.remove(this.getIndex(detail));
        }
        assert (result2.size() == this.myCache.size());
        this.mySortedDetails = result2;
    }

    @Nullable
    public VcsCommitMetadata get(int index) {
        return (VcsCommitMetadata)this.myCache.get(index);
    }

    public void clear() {
        this.myCache.clear();
        this.mySortedDetails.clear();
    }

    private static class MergingIterator
    implements Iterator<VcsCommitMetadata> {
        private final PeekingIterator<VcsCommitMetadata> myFirst;
        private final PeekingIterator<VcsCommitMetadata> mySecond;

        private MergingIterator(@NotNull List<VcsCommitMetadata> first, @NotNull List<VcsCommitMetadata> second) {
            if (first == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/vcs/log/data/TopCommitsCache$MergingIterator", "<init>"));
            }
            if (second == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/intellij/vcs/log/data/TopCommitsCache$MergingIterator", "<init>"));
            }
            this.myFirst = Iterators.peekingIterator(first.iterator());
            this.mySecond = Iterators.peekingIterator(second.iterator());
        }

        @Override
        public boolean hasNext() {
            return this.myFirst.hasNext() || this.mySecond.hasNext();
        }

        @Override
        public VcsCommitMetadata next() {
            if (!this.myFirst.hasNext()) {
                return (VcsCommitMetadata)this.mySecond.next();
            }
            if (!this.mySecond.hasNext()) {
                return (VcsCommitMetadata)this.myFirst.next();
            }
            VcsCommitMetadata data1 = (VcsCommitMetadata)this.myFirst.peek();
            VcsCommitMetadata data2 = (VcsCommitMetadata)this.mySecond.peek();
            if (data1.getTimestamp() > data2.getTimestamp()) {
                return (VcsCommitMetadata)this.myFirst.next();
            }
            return (VcsCommitMetadata)this.mySecond.next();
        }
    }
}

