/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.render.VcsRefPainter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReferencePopupBuilder {
    @NotNull
    private final JBPopup myPopup;
    @NotNull
    private final JBList myList;
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final SingleReferenceComponent myRendererComponent;
    @NotNull
    private final ListCellRenderer myCellRenderer;

    ReferencePopupBuilder(@NotNull RefGroup group, @NotNull VcsLogUiImpl ui) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/vcs/log/ui/frame/ReferencePopupBuilder", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/frame/ReferencePopupBuilder", "<init>"));
        }
        this.myUi = ui;
        this.myRendererComponent = new SingleReferenceComponent(new VcsRefPainter(ui.getColorManager(), false));
        this.myCellRenderer = (list, value, index, isSelected, cellHasFocus) -> {
            this.myRendererComponent.setReference((VcsRef)value);
            this.myRendererComponent.setSelected(isSelected);
            return this.myRendererComponent;
        };
        this.myList = this.createList(group);
        this.myPopup = this.createPopup();
    }

    private JBList createList(RefGroup group) {
        JBList list = new JBList((ListModel)ReferencePopupBuilder.createListModel(group));
        list.setCellRenderer(this.myCellRenderer);
        ListUtil.installAutoSelectOnMouseMove((JList)list);
        list.setSelectedIndex(0);
        list.setSelectionMode(0);
        this.jumpOnMouseClick(list);
        this.jumpOnEnter(list);
        return list;
    }

    private void jumpOnMouseClick(JBList list) {
        list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ReferencePopupBuilder.this.jumpToSelectedRef();
            }
        });
    }

    private void jumpOnEnter(JBList list) {
        list.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ReferencePopupBuilder.this.jumpToSelectedRef();
                }
            }
        });
    }

    private JBPopup createPopup() {
        return JBPopupFactory.getInstance().createComponentPopupBuilder(ListWithFilter.wrap((JList)this.myList, (JScrollPane)ScrollPaneFactory.createScrollPane((Component)this.myList), (Function)new Function<VcsRef, String>(){

            public String fun(VcsRef vcsRef) {
                return vcsRef.getName();
            }
        }), (JComponent)this.myList).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).setFocusable(true).setRequestFocus(true).setResizable(true).setDimensionServiceKey(this.myUi.getProject(), "Vcs.Log.Branch.Panel.RefGroup.Popup", false).createPopup();
    }

    private static DefaultListModel createListModel(RefGroup group) {
        DefaultListModel<VcsRef> model = new DefaultListModel<VcsRef>();
        for (VcsRef vcsRef : group.getRefs()) {
            model.addElement(vcsRef);
        }
        return model;
    }

    @NotNull
    JBPopup getPopup() {
        JBPopup jBPopup = this.myPopup;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/ReferencePopupBuilder", "getPopup"));
        }
        return jBPopup;
    }

    private void jumpToSelectedRef() {
        this.myPopup.cancel();
        VcsRef selectedRef = (VcsRef)this.myList.getSelectedValue();
        if (selectedRef != null) {
            this.myUi.jumpToCommit(selectedRef.getCommitHash(), selectedRef.getRoot());
        }
    }

    private static class SingleReferenceComponent
    extends JPanel {
        private static final int PADDING_Y = 2;
        private static final int PADDING_X = 5;
        @NotNull
        private final VcsRefPainter myReferencePainter;
        @Nullable
        private VcsRef myReference;
        public boolean mySelected;

        public SingleReferenceComponent(@NotNull VcsRefPainter referencePainter) {
            if (referencePainter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePainter", "com/intellij/vcs/log/ui/frame/ReferencePopupBuilder$SingleReferenceComponent", "<init>"));
            }
            this.myReferencePainter = referencePainter;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.mySelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.myReference != null) {
                this.myReferencePainter.paint(this.myReference, g, 5, 2);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.myReference == null) {
                return super.getPreferredSize();
            }
            Dimension size = this.myReferencePainter.getSize(this.myReference, (JComponent)this);
            return new Dimension(size.width + 10, size.height + 4);
        }

        public void setReference(@NotNull VcsRef reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/vcs/log/ui/frame/ReferencePopupBuilder$SingleReferenceComponent", "setReference"));
            }
            this.myReference = reference;
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
        }
    }
}

