/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerSupport;
import com.intellij.xdebugger.impl.actions.EditBreakpointAction;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.RemoveBreakpointGutterIconAction;
import com.intellij.xdebugger.impl.breakpoints.ToggleBreakpointGutterIconAction;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointDependencyState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointBase<Self extends XBreakpoint<P>, P extends XBreakpointProperties, S extends BreakpointState>
extends UserDataHolderBase
implements XBreakpoint<P>,
Comparable<Self> {
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    @NonNls
    private static final String BR_NBSP = "<br>&nbsp;";
    private final XBreakpointType<Self, P> myType;
    @Nullable
    private final P myProperties;
    protected final S myState;
    private final XBreakpointManagerImpl myBreakpointManager;
    private Icon myIcon;
    private CustomizedBreakpointPresentation myCustomizedPresentation;
    private boolean myConditionEnabled = true;
    private XExpression myCondition;
    private boolean myLogExpressionEnabled = true;
    private XExpression myLogExpression;

    public XBreakpointBase(XBreakpointType<Self, P> type, XBreakpointManagerImpl breakpointManager, @Nullable P properties, S state) {
        this.myState = state;
        this.myType = type;
        this.myProperties = properties;
        this.myBreakpointManager = breakpointManager;
        this.initExpressions();
    }

    protected XBreakpointBase(XBreakpointType<Self, P> type, XBreakpointManagerImpl breakpointManager, S breakpointState) {
        this.myState = breakpointState;
        this.myType = type;
        this.myBreakpointManager = breakpointManager;
        this.myProperties = type.createProperties();
        if (this.myProperties != null) {
            ComponentSerializationUtil.loadComponentState(this.myProperties, ((BreakpointState)this.myState).getPropertiesElement());
        }
        this.initExpressions();
    }

    private void initExpressions() {
        this.myConditionEnabled = ((BreakpointState)this.myState).isConditionEnabled();
        BreakpointState.Condition condition = ((BreakpointState)this.myState).getCondition();
        this.myCondition = condition != null ? condition.toXExpression() : null;
        this.myLogExpressionEnabled = ((BreakpointState)this.myState).isLogExpressionEnabled();
        BreakpointState.LogExpression expression = ((BreakpointState)this.myState).getLogExpression();
        this.myLogExpression = expression != null ? expression.toXExpression() : null;
    }

    public final Project getProject() {
        return this.myBreakpointManager.getProject();
    }

    protected XBreakpointManagerImpl getBreakpointManager() {
        return this.myBreakpointManager;
    }

    public final void fireBreakpointChanged() {
        this.clearIcon();
        this.myBreakpointManager.fireBreakpointChanged(this);
    }

    public XSourcePosition getSourcePosition() {
        return this.getType().getSourcePosition((XBreakpoint)this);
    }

    public Navigatable getNavigatable() {
        XSourcePosition position = this.getSourcePosition();
        if (position == null) {
            return null;
        }
        return position.createNavigatable(this.getProject());
    }

    public boolean isEnabled() {
        return ((BreakpointState)this.myState).isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            ((BreakpointState)this.myState).setEnabled(enabled);
            this.fireBreakpointChanged();
        }
    }

    @NotNull
    public SuspendPolicy getSuspendPolicy() {
        SuspendPolicy suspendPolicy = ((BreakpointState)this.myState).getSuspendPolicy();
        if (suspendPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase", "getSuspendPolicy"));
        }
        return suspendPolicy;
    }

    public void setSuspendPolicy(@NotNull SuspendPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase", "setSuspendPolicy"));
        }
        if (((BreakpointState)this.myState).getSuspendPolicy() != policy) {
            ((BreakpointState)this.myState).setSuspendPolicy(policy);
            this.fireBreakpointChanged();
        }
    }

    public boolean isLogMessage() {
        return ((BreakpointState)this.myState).isLogMessage();
    }

    public void setLogMessage(boolean logMessage) {
        if (logMessage != this.isLogMessage()) {
            ((BreakpointState)this.myState).setLogMessage(logMessage);
            this.fireBreakpointChanged();
        }
    }

    public boolean isConditionEnabled() {
        return this.myConditionEnabled;
    }

    public void setConditionEnabled(boolean conditionEnabled) {
        if (this.myConditionEnabled != conditionEnabled) {
            this.myConditionEnabled = conditionEnabled;
            this.fireBreakpointChanged();
        }
    }

    public boolean isLogExpressionEnabled() {
        return this.myLogExpressionEnabled;
    }

    public void setLogExpressionEnabled(boolean logExpressionEnabled) {
        if (this.myLogExpressionEnabled != logExpressionEnabled) {
            this.myLogExpressionEnabled = logExpressionEnabled;
            this.fireBreakpointChanged();
        }
    }

    public String getLogExpression() {
        XExpression expression = this.getLogExpressionObject();
        return expression != null ? expression.getExpression() : null;
    }

    public void setLogExpression(@Nullable String expression) {
        if (!Comparing.equal((String)this.getLogExpression(), (String)expression)) {
            this.myLogExpression = XExpressionImpl.fromText(expression);
            this.fireBreakpointChanged();
        }
    }

    public XExpression getLogExpressionObjectInt() {
        return this.myLogExpression;
    }

    @Nullable
    public XExpression getLogExpressionObject() {
        return this.myLogExpressionEnabled ? this.myLogExpression : null;
    }

    public void setLogExpressionObject(@Nullable XExpression expression) {
        if (!Comparing.equal((Object)this.myLogExpression, (Object)expression)) {
            this.myLogExpression = expression;
            this.fireBreakpointChanged();
        }
    }

    public String getCondition() {
        XExpression expression = this.getConditionExpression();
        return expression != null ? expression.getExpression() : null;
    }

    public void setCondition(@Nullable String condition) {
        if (!Comparing.equal((String)condition, (String)this.getCondition())) {
            this.myCondition = XExpressionImpl.fromText(condition);
            this.fireBreakpointChanged();
        }
    }

    public XExpression getConditionExpressionInt() {
        return this.myCondition;
    }

    @Nullable
    public XExpression getConditionExpression() {
        return this.myConditionEnabled ? this.myCondition : null;
    }

    public void setConditionExpression(@Nullable XExpression condition) {
        if (!Comparing.equal((Object)condition, (Object)this.myCondition)) {
            this.myCondition = condition;
            this.fireBreakpointChanged();
        }
    }

    public long getTimeStamp() {
        return ((BreakpointState)this.myState).getTimeStamp();
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public P getProperties() {
        return this.myProperties;
    }

    @NotNull
    public XBreakpointType<Self, P> getType() {
        XBreakpointType<Self, P> xBreakpointType = this.myType;
        if (xBreakpointType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase", "getType"));
        }
        return xBreakpointType;
    }

    public S getState() {
        Element propertiesElement = this.myProperties != null ? XmlSerializer.serialize((Object)this.myProperties.getState(), (SerializationFilter)SERIALIZATION_FILTERS) : null;
        ((BreakpointState)this.myState).setCondition(BreakpointState.Condition.create(!this.myConditionEnabled, this.myCondition));
        ((BreakpointState)this.myState).setLogExpression(BreakpointState.LogExpression.create(!this.myLogExpressionEnabled, this.myLogExpression));
        ((BreakpointState)this.myState).setPropertiesElement(propertiesElement);
        return this.myState;
    }

    public XBreakpointDependencyState getDependencyState() {
        return ((BreakpointState)this.myState).getDependencyState();
    }

    public void setDependencyState(XBreakpointDependencyState state) {
        ((BreakpointState)this.myState).setDependencyState(state);
    }

    public String getGroup() {
        return ((BreakpointState)this.myState).getGroup();
    }

    public void setGroup(String group) {
        ((BreakpointState)this.myState).setGroup(StringUtil.nullize((String)group));
    }

    public String getUserDescription() {
        return ((BreakpointState)this.myState).getDescription();
    }

    public void setUserDescription(String description) {
        ((BreakpointState)this.myState).setDescription(StringUtil.nullize((String)description));
    }

    public void dispose() {
    }

    public String toString() {
        return "XBreakpointBase(type=" + this.myType + ")";
    }

    @Nullable
    protected GutterDraggableObject createBreakpointDraggableObject() {
        return null;
    }

    protected List<? extends AnAction> getAdditionalPopupMenuActions(XDebugSession session2) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getDescription() {
        XBreakpoint<?> masterBreakpoint;
        String logExpression;
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append("<html>").append("<body>");
        builder.append(XBreakpointUtil.getDisplayText(this));
        String errorMessage = this.getErrorMessage();
        if (!StringUtil.isEmpty((String)errorMessage)) {
            builder.append(BR_NBSP);
            builder.append("<font color='#").append(ColorUtil.toHex((Color)JBColor.RED)).append("'>");
            builder.append(errorMessage);
            builder.append("</font>");
        }
        if (this.getSuspendPolicy() == SuspendPolicy.NONE) {
            builder.append(BR_NBSP).append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.suspend.policy.none", (Object[])new Object[0]));
        } else if (this.getType().isSuspendThreadSupported()) {
            builder.append(BR_NBSP);
            switch (this.getSuspendPolicy()) {
                case ALL: {
                    builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.suspend.policy.all", (Object[])new Object[0]));
                    break;
                }
                case THREAD: {
                    builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.suspend.policy.thread", (Object[])new Object[0]));
                }
            }
        }
        String condition = this.getCondition();
        if (!StringUtil.isEmpty((String)condition)) {
            builder.append(BR_NBSP);
            builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.condition", (Object[])new Object[0]));
            builder.append("&nbsp;");
            builder.append(XmlStringUtil.escapeString((String)condition));
        }
        if (this.isLogMessage()) {
            builder.append(BR_NBSP).append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.log.message", (Object[])new Object[0]));
        }
        if (!StringUtil.isEmpty((String)(logExpression = this.getLogExpression()))) {
            builder.append(BR_NBSP);
            builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.log.expression", (Object[])new Object[0]));
            builder.append("&nbsp;");
            builder.append(XmlStringUtil.escapeString((String)logExpression));
        }
        if ((masterBreakpoint = this.getBreakpointManager().getDependentBreakpointManager().getMasterBreakpoint(this)) != null) {
            builder.append(BR_NBSP);
            String str = XDebuggerBundle.message((String)"xbreakpoint.tooltip.depends.on", (Object[])new Object[0]);
            builder.append(str);
            builder.append("&nbsp;");
            builder.append(XBreakpointUtil.getShortText(masterBreakpoint));
        }
        builder.append("</body>").append("</html>");
        String string = builder.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase", "getDescription"));
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    protected void updateIcon() {
        Icon icon = this.calculateSpecialIcon();
        this.myIcon = icon != null ? icon : this.getType().getEnabledIcon();
    }

    protected void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    @Nullable
    protected final Icon calculateSpecialIcon() {
        Icon icon;
        XDebugSessionImpl session2 = this.getBreakpointManager().getDebuggerManager().getCurrentSession();
        if (!this.isEnabled()) {
            if (session2 == null || !session2.areBreakpointsMuted()) {
                return this.getType().getDisabledIcon();
            }
            return this.getType().getMutedDisabledIcon();
        }
        if (session2 == null) {
            if (this.getBreakpointManager().getDependentBreakpointManager().getMasterBreakpoint(this) != null) {
                return this.getType().getInactiveDependentIcon();
            }
        } else {
            Icon icon2;
            if (session2.areBreakpointsMuted()) {
                return this.getType().getMutedEnabledIcon();
            }
            if (session2.isInactiveSlaveBreakpoint(this)) {
                return this.getType().getInactiveDependentIcon();
            }
            CustomizedBreakpointPresentation presentation = session2.getBreakpointPresentation(this);
            if (presentation != null && (icon2 = presentation.getIcon()) != null) {
                return icon2;
            }
        }
        if (this.myCustomizedPresentation != null && (icon = this.myCustomizedPresentation.getIcon()) != null) {
            return icon;
        }
        return null;
    }

    public Icon getIcon() {
        if (this.myIcon == null) {
            this.updateIcon();
        }
        return this.myIcon;
    }

    @Nullable
    public String getErrorMessage() {
        String message;
        CustomizedBreakpointPresentation presentation;
        XDebugSessionImpl currentSession = this.getBreakpointManager().getDebuggerManager().getCurrentSession();
        if (currentSession != null && (presentation = currentSession.getBreakpointPresentation(this)) != null && (message = presentation.getErrorMessage()) != null) {
            return message;
        }
        return this.myCustomizedPresentation != null ? this.myCustomizedPresentation.getErrorMessage() : null;
    }

    CustomizedBreakpointPresentation getCustomizedPresentation() {
        return this.myCustomizedPresentation;
    }

    public void setCustomizedPresentation(CustomizedBreakpointPresentation presentation) {
        this.myCustomizedPresentation = presentation;
    }

    @NotNull
    public GutterIconRenderer createGutterIconRenderer() {
        BreakpointGutterIconRenderer breakpointGutterIconRenderer = new BreakpointGutterIconRenderer();
        if (breakpointGutterIconRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase", "createGutterIconRenderer"));
        }
        return breakpointGutterIconRenderer;
    }

    public void clearIcon() {
        this.myIcon = null;
    }

    @Override
    public int compareTo(@NotNull Self self) {
        if (self == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "self", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase", "compareTo"));
        }
        return this.myType.getBreakpointComparator().compare(this, self);
    }

    protected class BreakpointGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        protected BreakpointGutterIconRenderer() {
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = XBreakpointBase.this.getIcon();
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase$BreakpointGutterIconRenderer", "getIcon"));
            }
            return icon;
        }

        @Nullable
        public AnAction getClickAction() {
            if (Registry.is((String)"debugger.click.disable.breakpoints")) {
                return new ToggleBreakpointGutterIconAction(XBreakpointBase.this);
            }
            return new RemoveBreakpointGutterIconAction(XBreakpointBase.this);
        }

        @Nullable
        public AnAction getMiddleButtonClickAction() {
            if (!Registry.is((String)"debugger.click.disable.breakpoints")) {
                return new ToggleBreakpointGutterIconAction(XBreakpointBase.this);
            }
            return new RemoveBreakpointGutterIconAction(XBreakpointBase.this);
        }

        @Nullable
        public AnAction getRightButtonClickAction() {
            return new EditBreakpointAction.ContextAction(this, XBreakpointBase.this, DebuggerSupport.getDebuggerSupport(XDebuggerSupport.class));
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.RIGHT;
            if (alignment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase$BreakpointGutterIconRenderer", "getAlignment"));
            }
            return alignment;
        }

        @Nullable
        public ActionGroup getPopupMenuActions() {
            return null;
        }

        @Nullable
        public String getTooltipText() {
            return XBreakpointBase.this.getDescription();
        }

        public GutterDraggableObject getDraggableObject() {
            return XBreakpointBase.this.createBreakpointDraggableObject();
        }

        private XBreakpointBase<?, ?, ?> getBreakpoint() {
            return XBreakpointBase.this;
        }

        public boolean equals(Object obj) {
            return obj instanceof BreakpointGutterIconRenderer && this.getBreakpoint() == ((BreakpointGutterIconRenderer)((Object)obj)).getBreakpoint() && Comparing.equal((Object)this.getIcon(), (Object)((BreakpointGutterIconRenderer)((Object)obj)).getIcon());
        }

        public int hashCode() {
            return this.getBreakpoint().hashCode();
        }
    }
}

