/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.util.Comparing;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.XValueExtendedPresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NotNull;

public class XDebuggerTreeRestorer
implements XDebuggerTreeListener,
TreeSelectionListener {
    private final XDebuggerTree myTree;
    private final Rectangle myLastVisibleNodeRect;
    private final Map<XDebuggerTreeNode, XDebuggerTreeState.NodeInfo> myNode2State = new HashMap<XDebuggerTreeNode, XDebuggerTreeState.NodeInfo>();
    private final Map<RestorableStateNode, XDebuggerTreeState.NodeInfo> myNode2ParentState = new HashMap<RestorableStateNode, XDebuggerTreeState.NodeInfo>();
    private boolean myStopRestoringSelection;
    private boolean myInsideRestoring;

    public XDebuggerTreeRestorer(XDebuggerTree tree, Rectangle lastVisibleNodeRect) {
        this.myTree = tree;
        this.myLastVisibleNodeRect = lastVisibleNodeRect;
        tree.addTreeListener(this);
        tree.addTreeSelectionListener(this);
    }

    private void restoreChildren(XDebuggerTreeNode treeNode, XDebuggerTreeState.NodeInfo nodeInfo) {
        if (nodeInfo.isExpanded()) {
            this.myTree.expandPath(treeNode.getPath());
            treeNode.getLoadedChildren().forEach(child -> this.restoreNode((XDebuggerTreeNode)child, nodeInfo));
            this.myNode2State.put(treeNode, nodeInfo);
        }
    }

    void restore(XDebuggerTreeNode treeNode, XDebuggerTreeState.NodeInfo parentInfo) {
        if (treeNode instanceof RestorableStateNode) {
            this.doRestoreNode((RestorableStateNode)((Object)treeNode), parentInfo);
        } else {
            this.restoreChildren(treeNode, parentInfo);
        }
    }

    private void restoreNode(XDebuggerTreeNode treeNode, XDebuggerTreeState.NodeInfo parentInfo) {
        if (treeNode instanceof RestorableStateNode) {
            RestorableStateNode node = (RestorableStateNode)((Object)treeNode);
            if (node.isComputed()) {
                this.doRestoreNode(node, parentInfo.removeChild(node.getName()));
            } else {
                this.myNode2ParentState.put(node, parentInfo);
            }
        }
    }

    private void doRestoreNode(RestorableStateNode treeNode, XDebuggerTreeState.NodeInfo nodeInfo) {
        if (nodeInfo != null) {
            if (!XDebuggerTreeRestorer.checkExtendedModified(treeNode) && !Comparing.equal((String)nodeInfo.getValue(), (String)treeNode.getRawValue())) {
                treeNode.markChanged();
            }
            if (!this.myStopRestoringSelection && nodeInfo.isSelected()) {
                try {
                    this.myInsideRestoring = true;
                    this.myTree.addSelectionPath(treeNode.getPath());
                }
                finally {
                    this.myInsideRestoring = false;
                }
            }
            this.restoreChildren((XDebuggerTreeNode)((Object)treeNode), nodeInfo);
        } else if (!XDebuggerTreeRestorer.checkExtendedModified(treeNode)) {
            treeNode.markChanged();
        }
    }

    private static boolean checkExtendedModified(RestorableStateNode treeNode) {
        XValuePresentation presentation;
        if (treeNode instanceof XValueNodeImpl && (presentation = ((XValueNodeImpl)treeNode).getValuePresentation()) instanceof XValueExtendedPresentation) {
            if (((XValueExtendedPresentation)presentation).isModified()) {
                treeNode.markChanged();
            }
            return true;
        }
        return false;
    }

    @Override
    public void nodeLoaded(@NotNull RestorableStateNode node, String name) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRestorer", "nodeLoaded"));
        }
        XDebuggerTreeState.NodeInfo parentInfo = this.myNode2ParentState.remove(node);
        if (parentInfo != null) {
            this.doRestoreNode(node, parentInfo.removeChild(node.getName()));
        }
        this.disposeIfFinished();
    }

    private void disposeIfFinished() {
        if (this.myNode2ParentState.isEmpty() && this.myNode2State.isEmpty()) {
            if (this.myLastVisibleNodeRect != null) {
                this.myTree.scrollRectToVisible(this.myLastVisibleNodeRect);
            }
            this.dispose();
        }
    }

    @Override
    public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<XValueContainerNode<?>> children2, boolean last) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRestorer", "childrenLoaded"));
        }
        if (children2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRestorer", "childrenLoaded"));
        }
        XDebuggerTreeState.NodeInfo nodeInfo = this.myNode2State.get(node);
        if (nodeInfo != null) {
            for (XDebuggerTreeNode xDebuggerTreeNode : children2) {
                this.restoreNode(xDebuggerTreeNode, nodeInfo);
            }
        }
        if (last) {
            this.myNode2State.remove(node);
            this.disposeIfFinished();
        }
    }

    public void dispose() {
        this.myNode2ParentState.clear();
        this.myNode2State.clear();
        this.myTree.removeTreeListener(this);
        this.myTree.removeTreeSelectionListener(this);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.myInsideRestoring) {
            this.myStopRestoringSelection = true;
        }
    }
}

