/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XInspectDialog;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;

public class ShowReferringObjectsAction
extends XDebuggerTreeActionBase {
    @Override
    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/actions/ShowReferringObjectsAction", "isEnabled"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/actions/ShowReferringObjectsAction", "isEnabled"));
        }
        return ((XValue)node.getValueContainer()).getReferrersProvider() != null;
    }

    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        XDebuggerTree tree;
        XDebugSession session2;
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/xdebugger/impl/ui/tree/actions/ShowReferringObjectsAction", "perform"));
        }
        XReferrersProvider referrersProvider = ((XValue)node.getValueContainer()).getReferrersProvider();
        if (referrersProvider != null && (session2 = XDebuggerManager.getInstance((Project)(tree = node.getTree()).getProject()).getCurrentSession()) != null) {
            XInspectDialog dialog = new XInspectDialog(tree.getProject(), tree.getEditorsProvider(), tree.getSourcePosition(), nodeName, referrersProvider.getReferringObjectsValue(), tree.getValueMarkers(), session2, false);
            dialog.setTitle(XDebuggerBundle.message((String)"showReferring.dialog.title", (Object[])new Object[]{nodeName}));
            dialog.show();
        }
    }
}

