/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension.schema;

import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.jetbrains.jsonSchema.extension.schema.JsonSchemaBaseReference;
import com.jetbrains.jsonSchema.extension.schema.JsonSchemaDefinitionResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRefReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new JsonSchemaRefReference((JsonValue)element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class JsonSchemaRefReference
    extends JsonSchemaBaseReference<JsonValue> {
        public JsonSchemaRefReference(JsonValue element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @NotNull
        public String getCanonicalText() {
            String string = StringUtil.unquoteString((String)super.getCanonicalText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider$JsonSchemaRefReference", "getCanonicalText"));
            }
            return string;
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            boolean isGlobal;
            String text = this.getCanonicalText();
            String id = null;
            String ref = text.substring(1);
            boolean bl = isGlobal = !text.startsWith("#");
            if (isGlobal) {
                int idx = text.indexOf("#");
                if (idx <= 0) {
                    return null;
                }
                id = text.substring(0, idx);
                ref = text.substring(idx + 1);
            }
            return new JsonSchemaDefinitionResolver(this.getElement(), id).setRef(ref).setInCurrentFile(!isGlobal).doResolve();
        }
    }
}

