/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.controlflow.ConditionalUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TrivialIfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        if ("RedundantIfStatement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection", "getID"));
        }
        return "RedundantIfStatement";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("trivial.if.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("trivial.if.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new TrivialIfFix();
    }

    public static void simplify(PsiIfStatement statement2) {
        if (TrivialIfInspection.isSimplifiableAssignment(statement2)) {
            TrivialIfInspection.replaceSimplifiableAssignment(statement2);
        } else if (TrivialIfInspection.isSimplifiableReturn(statement2)) {
            TrivialIfInspection.replaceSimplifiableReturn(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitReturn(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitReturn(statement2);
        } else if (TrivialIfInspection.isSimplifiableAssignmentNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableAssignmentNegated(statement2);
        } else if (TrivialIfInspection.isSimplifiableReturnNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableReturnNegated(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitReturnNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitReturnNegated(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitAssignment(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitAssignment(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitAssignmentNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitAssignmentNegated(statement2);
        }
    }

    private static void replaceSimplifiableImplicitReturn(PsiIfStatement statement2) throws IncorrectOperationException {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class});
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, newStatement);
        assert (nextStatement != null);
        nextStatement.delete();
    }

    private static void replaceSimplifiableReturn(PsiIfStatement statement2) throws IncorrectOperationException {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        String newStatement = "return " + conditionText + ';';
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)statement2, PsiComment.class);
        PsiElement parent = statement2.getParent();
        for (PsiComment comment : comments) {
            parent.addBefore(comment.copy(), (PsiElement)statement2);
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, newStatement);
    }

    private static void replaceSimplifiableAssignment(PsiIfStatement statement2) throws IncorrectOperationException {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        List comments = ContainerUtil.map((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)statement2, PsiComment.class), comment -> (PsiComment)comment.copy());
        String conditionText = condition.getText();
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiElement parent = statement2.getParent();
        for (PsiComment comment2 : comments) {
            parent.addBefore((PsiElement)comment2, (PsiElement)statement2);
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, lhsText + operand + conditionText + ';');
    }

    private static void replaceSimplifiableImplicitAssignment(PsiIfStatement statement2) throws IncorrectOperationException {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prevStatement == null) {
            return;
        }
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, lhsText + operand + conditionText + ';');
        prevStatement.delete();
    }

    private static void replaceSimplifiableImplicitAssignmentNegated(PsiIfStatement statement2) {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class});
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, lhsText + operand + conditionText + ';');
        assert (prevStatement != null);
        prevStatement.delete();
    }

    private static void replaceSimplifiableImplicitReturnNegated(PsiIfStatement statement2) {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class});
        if (nextStatement == null) {
            return;
        }
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, newStatement);
        nextStatement.delete();
    }

    private static void replaceSimplifiableReturnNegated(PsiIfStatement statement2) {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, newStatement);
    }

    private static void replaceSimplifiableAssignmentNegated(PsiIfStatement statement2) {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, lhsText + operand + conditionText + ';');
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialIfVisitor();
    }

    public static boolean isTrivial(PsiIfStatement ifStatement) {
        if (PsiUtilCore.hasErrorElementChild((PsiElement)ifStatement)) {
            return false;
        }
        if (TrivialIfInspection.isSimplifiableAssignment(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableReturn(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableAssignmentNegated(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableReturnNegated(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableImplicitReturnNegated(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement)) {
            return true;
        }
        return TrivialIfInspection.isSimplifiableImplicitAssignmentNegated(ifStatement);
    }

    public static boolean isSimplifiableImplicitReturn(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement, "true", "false");
    }

    public static boolean isSimplifiableImplicitReturnNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement, "false", "true");
    }

    public static boolean isSimplifiableImplicitReturn(PsiIfStatement ifStatement, String thenReturn, String elseReturn) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        return ConditionalUtils.isReturn(thenBranch, thenReturn) && ConditionalUtils.isReturn(elseBranch, elseReturn);
    }

    public static boolean isSimplifiableReturn(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableReturn(ifStatement, "true", "false");
    }

    public static boolean isSimplifiableReturnNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableReturn(ifStatement, "false", "true");
    }

    public static boolean isSimplifiableReturn(PsiIfStatement ifStatement, String thenReturn, String elseReturn) {
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        return ConditionalUtils.isReturn(thenBranch, thenReturn) && ConditionalUtils.isReturn(elseBranch, elseReturn);
    }

    public static boolean isSimplifiableAssignment(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableAssignment(ifStatement, "true", "false");
    }

    public static boolean isSimplifiableAssignmentNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableAssignment(ifStatement, "false", "true");
    }

    public static boolean isSimplifiableAssignment(PsiIfStatement ifStatement, String thenAssignment, String elseAssignment) {
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        return TrivialIfInspection.isSimplifiableAssignment(thenBranch, elseBranch, thenAssignment, elseAssignment);
    }

    public static boolean isSimplifiableImplicitAssignment(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement, "true", "false");
    }

    public static boolean isSimplifiableImplicitAssignmentNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement, "false", "true");
    }

    public static boolean isSimplifiableImplicitAssignment(PsiIfStatement ifStatement, String thenAssignment, String elseAssignment) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        return TrivialIfInspection.isSimplifiableAssignment(thenBranch, elseBranch, thenAssignment, elseAssignment);
    }

    private static boolean isSimplifiableAssignment(PsiStatement thenBranch, PsiStatement elseBranch, String thenAssignment, String elseAssignment) {
        if (ConditionalUtils.isAssignment(thenBranch, thenAssignment) && ConditionalUtils.isAssignment(elseBranch, elseAssignment)) {
            PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
            PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenExpressionStatement.getExpression();
            PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
            PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseExpressionStatement.getExpression();
            IElementType thenTokenType = thenExpression.getOperationTokenType();
            if (!thenTokenType.equals(elseExpression.getOperationTokenType())) {
                return false;
            }
            PsiExpression thenLhs = thenExpression.getLExpression();
            PsiExpression elseLhs = elseExpression.getLExpression();
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    private static class TrivialIfVisitor
    extends BaseInspectionVisitor {
        private TrivialIfVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(ifStatement);
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            if (TrivialIfInspection.isTrivial(ifStatement)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
            }
        }
    }

    private static class TrivialIfFix
    extends InspectionGadgetsFix {
        private TrivialIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement ifKeywordElement = descriptor.getPsiElement();
            PsiIfStatement statement2 = (PsiIfStatement)ifKeywordElement.getParent();
            TrivialIfInspection.simplify(statement2);
        }
    }
}

