/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TestMethodIsPublicVoidNoArgInspectionBase
extends BaseInspection {
    public final List<String> ignorableAnnotations = new ArrayList<String>(Arrays.asList("mockit.Mocked"));

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("TestMethodWithIncorrectSignature" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspectionBase", "getID"));
        }
        return "TestMethodWithIncorrectSignature";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Problem problem = (Problem)((Object)infos[0]);
        switch (problem) {
            case PARAMETER: {
                String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor1", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspectionBase", "buildErrorString"));
                }
                return string;
            }
            case NOT_PUBLIC_VOID: {
                String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor2", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspectionBase", "buildErrorString"));
                }
                return string;
            }
            case STATIC: {
                String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor3", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspectionBase", "buildErrorString"));
                }
                return string;
            }
        }
        throw new AssertionError();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestMethodIsPublicVoidNoArgVisitor();
    }

    private class TestMethodIsPublicVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private TestMethodIsPublicVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspectionBase$TestMethodIsPublicVoidNoArgVisitor", "visitMethod"));
            }
            if (method.isConstructor()) {
                return;
            }
            if (!TestUtils.isJUnit3TestMethod(method) && !TestUtils.isJUnit4TestMethod(method)) {
                return;
            }
            PsiType returnType = method.getReturnType();
            PsiParameterList parameterList = method.getParameterList();
            if (method.hasModifierProperty("static")) {
                this.registerMethodError(method, new Object[]{Problem.STATIC});
                return;
            }
            if (parameterList.getParametersCount() != 0) {
                PsiParameter[] parameters = parameterList.getParameters();
                boolean annotated = true;
                for (PsiParameter parameter : parameters) {
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, TestMethodIsPublicVoidNoArgInspectionBase.this.ignorableAnnotations)) continue;
                    annotated = false;
                    break;
                }
                if (!annotated) {
                    this.registerMethodError(method, new Object[]{Problem.PARAMETER});
                    return;
                }
            }
            if (!PsiType.VOID.equals((Object)returnType) || !method.hasModifierProperty("public")) {
                this.registerMethodError(method, new Object[]{Problem.NOT_PUBLIC_VOID});
            }
        }
    }

    static enum Problem {
        STATIC,
        NOT_PUBLIC_VOID,
        PARAMETER;

    }
}

